<?php
require_once 'config/database.php';

$database = new Database();
$db = $database->getConnection();

echo "Testing Admin Manage Technicians...\n";

try {
    // Test get technicians
    $tech_query = "SELECT * FROM users WHERE role = 'teknisi' ORDER BY created_at DESC";
    $tech_stmt = $db->prepare($tech_query);
    $tech_stmt->execute();
    $technicians = $tech_stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "✓ Get technicians query successful\n";
    echo "Found " . count($technicians) . " technicians\n";
    
    // Test get customers
    $customers_query = "SELECT c.* FROM customers c 
                        LEFT JOIN installations i ON c.id = i.customer_id 
                        WHERE c.status = 'approved' AND i.id IS NULL
                        ORDER BY c.created_at DESC";
    $customers_stmt = $db->prepare($customers_query);
    $customers_stmt->execute();
    $customers = $customers_stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "✓ Get customers query successful\n";
    echo "Found " . count($customers) . " approved customers without installation\n";
    
    // Test get assignments
    $assignments_query = "SELECT i.*, c.nama_lengkap as customer_name, u.full_name as teknisi_name 
                          FROM installations i
                          JOIN customers c ON i.customer_id = c.id
                          JOIN users u ON i.teknisi_id = u.id
                          ORDER BY i.created_at DESC";
    $assignments_stmt = $db->prepare($assignments_query);
    $assignments_stmt->execute();
    $assignments = $assignments_stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "✓ Get assignments query successful\n";
    echo "Found " . count($assignments) . " assignments\n";
    
    echo "\nAll tests passed! ✅\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>

