# 1. Install dependencies
cd /home/lab-mji/ensia1
composer install

# 2. Setup database
mysql -u root -p
CREATE DATABASE ensia_db;
CREATE USER 'ensia_user'@'localhost' IDENTIFIED BY 'ensia_password';
GRANT ALL PRIVILEGES ON ensia_db.* TO 'ensia_user'@'localhost';
FLUSH PRIVILEGES;
EXIT;

# 3. Import database
mysql -u ensia_user -pensia_password ensia_db < database/schema.sql

# 4. Set permissions
chmod 755 uploads/ uploads/ktp/
mkdir -p /tmp/php_sessions && chmod 777 /tmp/php_sessions

# 5. Buat konfigurasi PHP
cat > php.ini << 'EOF'
[Session]
session.save_path = "/tmp/php_sessions"
session.gc_maxlifetime = 1440
session.cookie_lifetime = 0
session.use_cookies = 1
session.use_only_cookies = 1
session.cookie_httponly = 1
EOF

# 6. Jalankan server
php -S localhost:8080 -c php.ini

# 7. Buka browser
# http://localhost:8080
