<?php
require_once 'config/config.php';
requireRole(['admin', 'supervisor', 'teknisi']);

$database = new Database();
$db = $database->getConnection();

// Filter dan pencarian
$search = isset($_GET['search']) ? $_GET['search'] : '';
$status_filter = isset($_GET['status']) ? $_GET['status'] : '';
$date_filter = isset($_GET['date']) ? $_GET['date'] : '';

// Query untuk mendapatkan data pelanggan yang sudah selesai instalasi
$query = "SELECT 
            c.*,
            i.kabel_meter,
            i.latitude,
            i.longitude,
            i.alamat_instalasi,
            i.catatan,
            i.tanggal_instalasi,
            u.full_name as teknisi_name
          FROM customers c
          LEFT JOIN installations i ON c.id = i.customer_id
          LEFT JOIN users u ON i.teknisi_id = u.id
          WHERE c.status = 'installed'";

$params = [];

if (!empty($search)) {
    $query .= " AND (c.nama_lengkap LIKE ? OR c.email LIKE ? OR c.nomor_hp LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
    $params[] = "%$search%";
}

if (!empty($date_filter)) {
    if ($date_filter == 'today') {
        $query .= " AND DATE(i.tanggal_instalasi) = CURDATE()";
    } elseif ($date_filter == 'week') {
        $query .= " AND i.tanggal_instalasi >= DATE_SUB(NOW(), INTERVAL 1 WEEK)";
    } elseif ($date_filter == 'month') {
        $query .= " AND i.tanggal_instalasi >= DATE_SUB(NOW(), INTERVAL 1 MONTH)";
    }
}

$query .= " ORDER BY i.tanggal_instalasi DESC";

$stmt = $db->prepare($query);
$stmt->execute($params);
$customers = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Kategorisasi data
$categories = [
    'today' => [],
    'this_week' => [],
    'this_month' => [],
    'older' => []
];

$today = date('Y-m-d');
$week_start = date('Y-m-d', strtotime('monday this week'));
$month_start = date('Y-m-01');

foreach ($customers as $customer) {
    $install_date = $customer['tanggal_instalasi'];
    
    if ($install_date == $today) {
        $categories['today'][] = $customer;
    } elseif ($install_date >= $week_start) {
        $categories['this_week'][] = $customer;
    } elseif ($install_date >= $month_start) {
        $categories['this_month'][] = $customer;
    } else {
        $categories['older'][] = $customer;
    }
}

// Statistik
$stats = [
    'total' => count($customers),
    'today' => count($categories['today']),
    'this_week' => count($categories['this_week']),
    'this_month' => count($categories['this_month']),
    'older' => count($categories['older'])
];
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pelanggan Selesai Instalasi - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .sidebar .logo {
            padding: 1rem;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        .sidebar .logo i {
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.8);
            padding: 0.75rem 1rem;
            border-radius: 0.375rem;
            margin: 0.25rem 0.5rem;
        }
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background: rgba(255,255,255,0.1);
        }
        .main-content {
            background: #f8f9fa;
            min-height: 100vh;
        }
        .header {
            background: white;
            padding: 1rem 2rem;
            border-bottom: 1px solid #dee2e6;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
        }
        .category-card {
            background: white;
            border-radius: 0.5rem;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
            border-left: 4px solid;
        }
        .category-card.today { border-left-color: #28a745; }
        .category-card.week { border-left-color: #17a2b8; }
        .category-card.month { border-left-color: #ffc107; }
        .category-card.older { border-left-color: #6c757d; }
        .customer-card {
            background: #f8f9fa;
            border-radius: 0.375rem;
            padding: 1rem;
            margin-bottom: 0.75rem;
            border: 1px solid #dee2e6;
            transition: all 0.3s ease;
        }
        .customer-card:hover {
            box-shadow: 0 0.25rem 0.5rem rgba(0,0,0,0.1);
            transform: translateY(-2px);
        }
        .status-badge {
            font-size: 0.75rem;
        }
        .stats-card {
            background: white;
            border-radius: 0.5rem;
            padding: 1.5rem;
            text-align: center;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
            margin-bottom: 1.5rem;
        }
        .stats-card h3 {
            color: #667eea;
            margin-bottom: 0.5rem;
        }
        .search-box {
            background: white;
            border-radius: 0.5rem;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
        }
        .empty-state {
            text-align: center;
            padding: 3rem;
            color: #6c757d;
        }
        .empty-state i {
            font-size: 3rem;
            margin-bottom: 1rem;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0">
                <div class="sidebar">
                    <div class="logo">
                        <i class="fas fa-wifi"></i>
                        <h6 class="mb-0"><?php echo APP_NAME; ?></h6>
                        <small><?php echo APP_COMPANY; ?></small>
                    </div>
                    <nav class="nav flex-column mt-3">
                        <a class="nav-link" href="dashboard.php">
                            <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                        </a>
                        <?php if ($_SESSION['user_role'] == 'admin'): ?>
                        <a class="nav-link" href="customers.php">
                            <i class="fas fa-users me-2"></i>Data Pelanggan
                        </a>
                        <a class="nav-link" href="add_customer.php">
                            <i class="fas fa-user-plus me-2"></i>Tambah Pelanggan
                        </a>
                        <?php endif; ?>
                        <?php if ($_SESSION['user_role'] == 'supervisor'): ?>
                        <a class="nav-link" href="approvals.php">
                            <i class="fas fa-check-circle me-2"></i>Persetujuan
                        </a>
                        <?php endif; ?>
                        <?php if ($_SESSION['user_role'] == 'teknisi'): ?>
                        <a class="nav-link" href="installations.php">
                            <i class="fas fa-tools me-2"></i>Instalasi
                        </a>
                        <?php endif; ?>
                        <a class="nav-link active" href="installed_customers.php">
                            <i class="fas fa-check-double me-2"></i>Selesai Instalasi
                        </a>
                        <?php if ($_SESSION['user_role'] == 'admin'): ?>
                        <a class="nav-link" href="reports.php">
                            <i class="fas fa-chart-bar me-2"></i>Laporan
                        </a>
                        <?php endif; ?>
                        <a class="nav-link" href="logout.php">
                            <i class="fas fa-sign-out-alt me-2"></i>Logout
                        </a>
                    </nav>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-0">
                <div class="main-content">
                    <!-- Header -->
                    <div class="header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="mb-0">
                                <i class="fas fa-check-double me-2"></i>Pelanggan Selesai Instalasi
                            </h4>
                            <div class="d-flex align-items-center">
                                <span class="me-3">Selamat datang, <?php echo $_SESSION['full_name']; ?></span>
                                <span class="badge bg-primary"><?php echo ucfirst($_SESSION['user_role']); ?></span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Content -->
                    <div class="p-4">
                        <!-- Statistik -->
                        <div class="row mb-4">
                            <div class="col-md-3">
                                <div class="stats-card">
                                    <h3><?php echo $stats['total']; ?></h3>
                                    <p class="text-muted mb-0">Total Selesai</p>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="stats-card">
                                    <h3 class="text-success"><?php echo $stats['today']; ?></h3>
                                    <p class="text-muted mb-0">Hari Ini</p>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="stats-card">
                                    <h3 class="text-info"><?php echo $stats['this_week']; ?></h3>
                                    <p class="text-muted mb-0">Minggu Ini</p>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="stats-card">
                                    <h3 class="text-warning"><?php echo $stats['this_month']; ?></h3>
                                    <p class="text-muted mb-0">Bulan Ini</p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Search & Filter -->
                        <div class="search-box">
                            <form method="GET" class="row g-3">
                                <div class="col-md-4">
                                    <label class="form-label">Pencarian</label>
                                    <input type="text" class="form-control" name="search" 
                                           value="<?php echo htmlspecialchars($search); ?>" 
                                           placeholder="Nama, email, atau nomor HP...">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Filter Tanggal</label>
                                    <select class="form-select" name="date">
                                        <option value="">Semua Tanggal</option>
                                        <option value="today" <?php echo $date_filter == 'today' ? 'selected' : ''; ?>>Hari Ini</option>
                                        <option value="week" <?php echo $date_filter == 'week' ? 'selected' : ''; ?>>Minggu Ini</option>
                                        <option value="month" <?php echo $date_filter == 'month' ? 'selected' : ''; ?>>Bulan Ini</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">&nbsp;</label>
                                    <div class="d-grid">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-search me-2"></i>Cari
                                        </button>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label">&nbsp;</label>
                                    <div class="d-grid">
                                        <a href="installed_customers.php" class="btn btn-outline-secondary">
                                            <i class="fas fa-refresh me-2"></i>Reset
                                        </a>
                                    </div>
                                </div>
                            </form>
                        </div>
                        
                        <!-- Kategori Hari Ini -->
                        <?php if (!empty($categories['today'])): ?>
                        <div class="category-card today">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h5 class="mb-0">
                                    <i class="fas fa-calendar-day me-2"></i>Hari Ini
                                    <span class="badge bg-success ms-2"><?php echo count($categories['today']); ?></span>
                                </h5>
                                <small class="text-muted"><?php echo date('d F Y'); ?></small>
                            </div>
                            <div class="row">
                                <?php foreach ($categories['today'] as $customer): ?>
                                <div class="col-md-6 col-lg-4">
                                    <div class="customer-card">
                                        <div class="d-flex justify-content-between align-items-start mb-2">
                                            <h6 class="mb-0"><?php echo htmlspecialchars($customer['nama_lengkap']); ?></h6>
                                            <span class="badge bg-success status-badge">Selesai</span>
                                        </div>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-envelope me-1"></i><?php echo htmlspecialchars($customer['email']); ?>
                                        </p>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-phone me-1"></i><?php echo htmlspecialchars($customer['nomor_hp']); ?>
                                        </p>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-map-marker-alt me-1"></i><?php echo htmlspecialchars($customer['alamat_instalasi']); ?>
                                        </p>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-ruler me-1"></i><?php echo $customer['kabel_meter']; ?> meter
                                        </p>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-user-tie me-1"></i><?php echo htmlspecialchars($customer['teknisi_name']); ?>
                                        </p>
                                        <p class="text-muted small mb-0">
                                            <i class="fas fa-clock me-1"></i><?php echo date('H:i', strtotime($customer['tanggal_instalasi'])); ?>
                                        </p>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Kategori Minggu Ini -->
                        <?php if (!empty($categories['this_week'])): ?>
                        <div class="category-card week">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h5 class="mb-0">
                                    <i class="fas fa-calendar-week me-2"></i>Minggu Ini
                                    <span class="badge bg-info ms-2"><?php echo count($categories['this_week']); ?></span>
                                </h5>
                                <small class="text-muted"><?php echo date('d F Y', strtotime('monday this week')); ?> - <?php echo date('d F Y', strtotime('sunday this week')); ?></small>
                            </div>
                            <div class="row">
                                <?php foreach ($categories['this_week'] as $customer): ?>
                                <div class="col-md-6 col-lg-4">
                                    <div class="customer-card">
                                        <div class="d-flex justify-content-between align-items-start mb-2">
                                            <h6 class="mb-0"><?php echo htmlspecialchars($customer['nama_lengkap']); ?></h6>
                                            <span class="badge bg-info status-badge">Selesai</span>
                                        </div>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-envelope me-1"></i><?php echo htmlspecialchars($customer['email']); ?>
                                        </p>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-phone me-1"></i><?php echo htmlspecialchars($customer['nomor_hp']); ?>
                                        </p>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-map-marker-alt me-1"></i><?php echo htmlspecialchars($customer['alamat_instalasi']); ?>
                                        </p>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-ruler me-1"></i><?php echo $customer['kabel_meter']; ?> meter
                                        </p>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-user-tie me-1"></i><?php echo htmlspecialchars($customer['teknisi_name']); ?>
                                        </p>
                                        <p class="text-muted small mb-0">
                                            <i class="fas fa-calendar me-1"></i><?php echo date('d M Y', strtotime($customer['tanggal_instalasi'])); ?>
                                        </p>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Kategori Bulan Ini -->
                        <?php if (!empty($categories['this_month'])): ?>
                        <div class="category-card month">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h5 class="mb-0">
                                    <i class="fas fa-calendar-alt me-2"></i>Bulan Ini
                                    <span class="badge bg-warning ms-2"><?php echo count($categories['this_month']); ?></span>
                                </h5>
                                <small class="text-muted"><?php echo date('F Y'); ?></small>
                            </div>
                            <div class="row">
                                <?php foreach ($categories['this_month'] as $customer): ?>
                                <div class="col-md-6 col-lg-4">
                                    <div class="customer-card">
                                        <div class="d-flex justify-content-between align-items-start mb-2">
                                            <h6 class="mb-0"><?php echo htmlspecialchars($customer['nama_lengkap']); ?></h6>
                                            <span class="badge bg-warning status-badge">Selesai</span>
                                        </div>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-envelope me-1"></i><?php echo htmlspecialchars($customer['email']); ?>
                                        </p>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-phone me-1"></i><?php echo htmlspecialchars($customer['nomor_hp']); ?>
                                        </p>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-map-marker-alt me-1"></i><?php echo htmlspecialchars($customer['alamat_instalasi']); ?>
                                        </p>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-ruler me-1"></i><?php echo $customer['kabel_meter']; ?> meter
                                        </p>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-user-tie me-1"></i><?php echo htmlspecialchars($customer['teknisi_name']); ?>
                                        </p>
                                        <p class="text-muted small mb-0">
                                            <i class="fas fa-calendar me-1"></i><?php echo date('d M Y', strtotime($customer['tanggal_instalasi'])); ?>
                                        </p>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Kategori Lebih Lama -->
                        <?php if (!empty($categories['older'])): ?>
                        <div class="category-card older">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h5 class="mb-0">
                                    <i class="fas fa-history me-2"></i>Sebelumnya
                                    <span class="badge bg-secondary ms-2"><?php echo count($categories['older']); ?></span>
                                </h5>
                                <small class="text-muted">Instalasi sebelumnya</small>
                            </div>
                            <div class="row">
                                <?php foreach ($categories['older'] as $customer): ?>
                                <div class="col-md-6 col-lg-4">
                                    <div class="customer-card">
                                        <div class="d-flex justify-content-between align-items-start mb-2">
                                            <h6 class="mb-0"><?php echo htmlspecialchars($customer['nama_lengkap']); ?></h6>
                                            <span class="badge bg-secondary status-badge">Selesai</span>
                                        </div>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-envelope me-1"></i><?php echo htmlspecialchars($customer['email']); ?>
                                        </p>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-phone me-1"></i><?php echo htmlspecialchars($customer['nomor_hp']); ?>
                                        </p>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-map-marker-alt me-1"></i><?php echo htmlspecialchars($customer['alamat_instalasi']); ?>
                                        </p>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-ruler me-1"></i><?php echo $customer['kabel_meter']; ?> meter
                                        </p>
                                        <p class="text-muted small mb-1">
                                            <i class="fas fa-user-tie me-1"></i><?php echo htmlspecialchars($customer['teknisi_name']); ?>
                                        </p>
                                        <p class="text-muted small mb-0">
                                            <i class="fas fa-calendar me-1"></i><?php echo date('d M Y', strtotime($customer['tanggal_instalasi'])); ?>
                                        </p>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Empty State -->
                        <?php if (empty($customers)): ?>
                        <div class="empty-state">
                            <i class="fas fa-inbox"></i>
                            <h5>Tidak ada data</h5>
                            <p>Belum ada pelanggan yang selesai instalasi.</p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
