<?php
// Engineer On Site App (ENSIA) - Installation Script
// PT Maintek Juara Intisolusi

// Check if already installed
if (file_exists('config/installed.lock')) {
    die('Aplikasi sudah terinstall. Hapus file config/installed.lock untuk menginstall ulang.');
}

$step = $_GET['step'] ?? 1;
$error = '';
$success = '';

// Step 1: Database Configuration
if ($step == 1 && $_POST) {
    $host = $_POST['host'] ?? 'localhost';
    $dbname = $_POST['dbname'] ?? 'ensia_db';
    $username = $_POST['username'] ?? 'root';
    $password = $_POST['password'] ?? '';
    
    // Test database connection
    try {
        $pdo = new PDO("mysql:host=$host", $username, $password);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // Create database if not exists
        $pdo->exec("CREATE DATABASE IF NOT EXISTS `$dbname`");
        $pdo->exec("USE `$dbname`");
        
        // Read and execute schema
        $schema = file_get_contents('database/schema.sql');
        $pdo->exec($schema);
        
        // Update config file
        $config_content = file_get_contents('config/database.php');
        $config_content = str_replace("'localhost'", "'$host'", $config_content);
        $config_content = str_replace("'ensia_db'", "'$dbname'", $config_content);
        $config_content = str_replace("'root'", "'$username'", $config_content);
        $config_content = str_replace("''", "'$password'", $config_content);
        file_put_contents('config/database.php', $config_content);
        
        // Create installed lock file
        file_put_contents('config/installed.lock', date('Y-m-d H:i:s'));
        
        $success = 'Database berhasil dikonfigurasi!';
        $step = 2;
    } catch (PDOException $e) {
        $error = 'Error koneksi database: ' . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instalasi - <?php echo APP_NAME ?? 'ENSIA'; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        .install-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        .install-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 2rem;
            text-align: center;
        }
        .logo {
            width: 80px;
            height: 80px;
            background: white;
            border-radius: 50%;
            margin: 0 auto 1rem;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            color: #667eea;
            font-weight: bold;
        }
        .install-body {
            padding: 2rem;
        }
        .step-indicator {
            display: flex;
            justify-content: center;
            margin-bottom: 2rem;
        }
        .step {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 10px;
            font-weight: bold;
        }
        .step.active {
            background: #667eea;
            color: white;
        }
        .step.completed {
            background: #28a745;
            color: white;
        }
        .step.pending {
            background: #e9ecef;
            color: #6c757d;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6">
                <div class="install-card">
                    <div class="install-header">
                        <div class="logo">
                            <i class="fas fa-wifi"></i>
                        </div>
                        <h4 class="mb-1">Engineer On Site App (ENSIA)</h4>
                        <p class="mb-0">PT Maintek Juara Intisolusi</p>
                    </div>
                    <div class="install-body">
                        <!-- Step Indicator -->
                        <div class="step-indicator">
                            <div class="step <?php echo $step >= 1 ? ($step > 1 ? 'completed' : 'active') : 'pending'; ?>">1</div>
                            <div class="step <?php echo $step >= 2 ? ($step > 2 ? 'completed' : 'active') : 'pending'; ?>">2</div>
                            <div class="step <?php echo $step >= 3 ? 'active' : 'pending'; ?>">3</div>
                        </div>
                        
                        <?php if ($error): ?>
                            <div class="alert alert-danger" role="alert">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                <?php echo $error; ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($success): ?>
                            <div class="alert alert-success" role="alert">
                                <i class="fas fa-check-circle me-2"></i>
                                <?php echo $success; ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($step == 1): ?>
                            <!-- Step 1: Database Configuration -->
                            <h5 class="mb-3">Konfigurasi Database</h5>
                            <p class="text-muted mb-4">Masukkan informasi koneksi database MySQL Anda.</p>
                            
                            <form method="POST">
                                <div class="mb-3">
                                    <label for="host" class="form-label">Host Database</label>
                                    <input type="text" class="form-control" id="host" name="host" value="localhost" required>
                                </div>
                                <div class="mb-3">
                                    <label for="dbname" class="form-label">Nama Database</label>
                                    <input type="text" class="form-control" id="dbname" name="dbname" value="ensia_db" required>
                                </div>
                                <div class="mb-3">
                                    <label for="username" class="form-label">Username Database</label>
                                    <input type="text" class="form-control" id="username" name="username" value="root" required>
                                </div>
                                <div class="mb-3">
                                    <label for="password" class="form-label">Password Database</label>
                                    <input type="password" class="form-control" id="password" name="password">
                                </div>
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="fas fa-database me-2"></i>Konfigurasi Database
                                </button>
                            </form>
                            
                        <?php elseif ($step == 2): ?>
                            <!-- Step 2: Installation Complete -->
                            <h5 class="mb-3">Instalasi Berhasil!</h5>
                            <p class="text-muted mb-4">Aplikasi ENSIA telah berhasil diinstall dan siap digunakan.</p>
                            
                            <div class="alert alert-info">
                                <h6><i class="fas fa-info-circle me-2"></i>Informasi Login Default:</h6>
                                <ul class="mb-0">
                                    <li><strong>Admin:</strong> admin@ensia.com / password</li>
                                    <li><strong>Supervisor:</strong> supervisor@ensia.com / password</li>
                                    <li><strong>Teknisi:</strong> teknisi1@ensia.com / password</li>
                                </ul>
                                <small class="text-danger">PENTING: Ganti password default setelah login pertama!</small>
                            </div>
                            
                            <div class="d-grid gap-2">
                                <a href="login.php" class="btn btn-success">
                                    <i class="fas fa-sign-in-alt me-2"></i>Masuk ke Aplikasi
                                </a>
                                <a href="README.md" class="btn btn-outline-secondary" target="_blank">
                                    <i class="fas fa-book me-2"></i>Baca Dokumentasi
                                </a>
                            </div>
                            
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
