<?php
// File untuk menampilkan semua grafik dalam satu halaman
require_once 'config/database.php';

$database = new Database();
$db = $database->getConnection();

// Data untuk semua periode
$periods = ['day', 'week', 'month'];
$all_chart_data = [];

foreach ($periods as $period) {
    $chart_labels = [];
    $chart_values = [];
    
    if ($period == 'day') {
        // Data per hari (30 hari terakhir)
        $query = "SELECT 
                    DATE(created_at) as tanggal,
                    COUNT(*) as total
                  FROM customers 
                  WHERE status = 'installed' 
                  AND created_at >= DATE_SUB(NOW(), INTERVAL 30 DAY)
                  GROUP BY DATE(created_at)
                  ORDER BY tanggal ASC";
        $stmt = $db->prepare($query);
        $stmt->execute();
        $chart_data = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        foreach ($chart_data as $data) {
            $chart_labels[] = date('d M', strtotime($data['tanggal']));
            $chart_values[] = $data['total'];
        }
    } elseif ($period == 'week') {
        // Data per minggu (12 minggu terakhir)
        $query = "SELECT 
                    YEARWEEK(created_at, 1) as minggu,
                    COUNT(*) as total
                  FROM customers 
                  WHERE status = 'installed' 
                  AND created_at >= DATE_SUB(NOW(), INTERVAL 12 WEEK)
                  GROUP BY YEARWEEK(created_at, 1)
                  ORDER BY minggu ASC";
        $stmt = $db->prepare($query);
        $stmt->execute();
        $chart_data = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        foreach ($chart_data as $data) {
            $year = substr($data['minggu'], 0, 4);
            $week = substr($data['minggu'], 4, 2);
            $chart_labels[] = "Minggu $week $year";
            $chart_values[] = $data['total'];
        }
    } else {
        // Data per bulan (6 bulan terakhir)
        $query = "SELECT 
                    DATE_FORMAT(created_at, '%Y-%m') as bulan,
                    COUNT(*) as total
                  FROM customers 
                  WHERE status = 'installed' 
                  AND created_at >= DATE_SUB(NOW(), INTERVAL 6 MONTH)
                  GROUP BY DATE_FORMAT(created_at, '%Y-%m')
                  ORDER BY bulan ASC";
        $stmt = $db->prepare($query);
        $stmt->execute();
        $chart_data = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        foreach ($chart_data as $data) {
            $chart_labels[] = date('M Y', strtotime($data['bulan'] . '-01'));
            $chart_values[] = $data['total'];
        }
    }
    
    $all_chart_data[$period] = [
        'labels' => $chart_labels,
        'values' => $chart_values,
        'total' => array_sum($chart_values),
        'count' => count($chart_values)
    ];
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Semua Grafik Pemasangan - ENSIA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 2rem 0;
        }
        .chart-container {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            margin: 2rem 0;
        }
        .chart-wrapper {
            position: relative;
            height: 300px;
            width: 100%;
        }
        .header {
            text-align: center;
            color: white;
            margin-bottom: 2rem;
        }
        .header h1 {
            font-size: 2.5rem;
            margin-bottom: 0.5rem;
        }
        .stats-card {
            background: white;
            border-radius: 10px;
            padding: 1.5rem;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            margin-bottom: 1rem;
        }
        .stats-card h3 {
            color: #667eea;
            margin-bottom: 0.5rem;
        }
        .chart-title {
            color: #667eea;
            margin-bottom: 1rem;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1><i class="fas fa-wifi me-3"></i>ENSIA</h1>
            <p>Engineer On Site App - PT Maintek Juara Intisolusi</p>
            <h3>📊 Semua Grafik Pemasangan Internet</h3>
        </div>
        
        <!-- Overall Stats -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="stats-card">
                    <h3><?php echo $all_chart_data['month']['total']; ?></h3>
                    <p>Total Pemasangan (Bulan)</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stats-card">
                    <h3><?php echo $all_chart_data['week']['total']; ?></h3>
                    <p>Total Pemasangan (Minggu)</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stats-card">
                    <h3><?php echo $all_chart_data['day']['total']; ?></h3>
                    <p>Total Pemasangan (Hari)</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stats-card">
                    <h3><?php echo $all_chart_data['month']['count']; ?></h3>
                    <p>Data Points</p>
                </div>
            </div>
        </div>
        
        <!-- Grafik Per Bulan -->
        <div class="chart-container">
            <h4 class="chart-title">
                <i class="fas fa-calendar-alt me-2"></i>
                Grafik Pemasangan per Bulan (6 bulan terakhir)
            </h4>
            <div class="chart-wrapper">
                <canvas id="monthChart"></canvas>
            </div>
        </div>
        
        <!-- Grafik Per Minggu -->
        <div class="chart-container">
            <h4 class="chart-title">
                <i class="fas fa-calendar-week me-2"></i>
                Grafik Pemasangan per Minggu (12 minggu terakhir)
            </h4>
            <div class="chart-wrapper">
                <canvas id="weekChart"></canvas>
            </div>
        </div>
        
        <!-- Grafik Per Hari -->
        <div class="chart-container">
            <h4 class="chart-title">
                <i class="fas fa-calendar-day me-2"></i>
                Grafik Pemasangan per Hari (30 hari terakhir)
            </h4>
            <div class="chart-wrapper">
                <canvas id="dayChart"></canvas>
            </div>
        </div>
        
        <!-- Footer -->
        <div class="text-center mt-4">
            <p class="text-white">
                <i class="fas fa-code me-2"></i>
                Developed by Amiruloh untuk Tugas Akhir D3 Manajemen Informatika AMIK CBI Sukabumi
            </p>
            <a href="show_chart.php" class="btn btn-light me-2">
                <i class="fas fa-chart-line me-2"></i>Grafik Interaktif
            </a>
            <a href="login.php" class="btn btn-outline-light">
                <i class="fas fa-sign-in-alt me-2"></i>Login ke Aplikasi
            </a>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Konfigurasi umum untuk semua grafik
        const chartConfig = {
            type: 'line',
            options: {
                responsive: true,
                maintainAspectRatio: false,
                aspectRatio: 3,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1,
                            precision: 0
                        },
                        grid: {
                            color: 'rgba(0,0,0,0.1)'
                        }
                    },
                    x: {
                        grid: {
                            color: 'rgba(0,0,0,0.1)'
                        }
                    }
                },
                plugins: {
                    legend: {
                        display: true,
                        position: 'top'
                    },
                    tooltip: {
                        mode: 'index',
                        intersect: false,
                        backgroundColor: 'rgba(0,0,0,0.8)',
                        titleColor: '#ffffff',
                        bodyColor: '#ffffff',
                        borderColor: '#667eea',
                        borderWidth: 1
                    }
                },
                interaction: {
                    mode: 'nearest',
                    axis: 'x',
                    intersect: false
                }
            }
        };
        
        // Grafik Per Bulan
        const monthCtx = document.getElementById('monthChart').getContext('2d');
        new Chart(monthCtx, {
            ...chartConfig,
            data: {
                labels: <?php echo json_encode($all_chart_data['month']['labels']); ?>,
                datasets: [{
                    label: 'Pemasangan per Bulan',
                    data: <?php echo json_encode($all_chart_data['month']['values']); ?>,
                    borderColor: '#667eea',
                    backgroundColor: 'rgba(102, 126, 234, 0.1)',
                    tension: 0.4,
                    fill: true,
                    pointBackgroundColor: '#667eea',
                    pointBorderColor: '#ffffff',
                    pointBorderWidth: 2,
                    pointRadius: 5,
                    pointHoverRadius: 7
                }]
            }
        });
        
        // Grafik Per Minggu
        const weekCtx = document.getElementById('weekChart').getContext('2d');
        new Chart(weekCtx, {
            ...chartConfig,
            data: {
                labels: <?php echo json_encode($all_chart_data['week']['labels']); ?>,
                datasets: [{
                    label: 'Pemasangan per Minggu',
                    data: <?php echo json_encode($all_chart_data['week']['values']); ?>,
                    borderColor: '#28a745',
                    backgroundColor: 'rgba(40, 167, 69, 0.1)',
                    tension: 0.4,
                    fill: true,
                    pointBackgroundColor: '#28a745',
                    pointBorderColor: '#ffffff',
                    pointBorderWidth: 2,
                    pointRadius: 5,
                    pointHoverRadius: 7
                }]
            }
        });
        
        // Grafik Per Hari
        const dayCtx = document.getElementById('dayChart').getContext('2d');
        new Chart(dayCtx, {
            ...chartConfig,
            data: {
                labels: <?php echo json_encode($all_chart_data['day']['labels']); ?>,
                datasets: [{
                    label: 'Pemasangan per Hari',
                    data: <?php echo json_encode($all_chart_data['day']['values']); ?>,
                    borderColor: '#dc3545',
                    backgroundColor: 'rgba(220, 53, 69, 0.1)',
                    tension: 0.4,
                    fill: true,
                    pointBackgroundColor: '#dc3545',
                    pointBorderColor: '#ffffff',
                    pointBorderWidth: 2,
                    pointRadius: 5,
                    pointHoverRadius: 7
                }]
            }
        });
    </script>
</body>
</html>
