<?php
require_once 'config/config.php';
requireRole(['admin']);

$database = new Database();
$db = $database->getConnection();

$success = '';
$error = '';

if ($_POST) {
    $nama_lengkap = sanitizeInput($_POST['nama_lengkap']);
    $pekerjaan = sanitizeInput($_POST['pekerjaan']);
    $alamat_lengkap = sanitizeInput($_POST['alamat_lengkap']);
    $nomor_hp = sanitizeInput($_POST['nomor_hp']);
    $email = sanitizeInput($_POST['email']);
    $nik_ktp = sanitizeInput($_POST['nik_ktp']);
    
    // Validasi NIK KTP
    if (strlen($nik_ktp) != 16 || !is_numeric($nik_ktp)) {
        $error = 'NIK KTP harus 16 digit angka!';
    } else {
        // Cek apakah NIK sudah ada
        $check_query = "SELECT id FROM customers WHERE nik_ktp = ?";
        $check_stmt = $db->prepare($check_query);
        $check_stmt->execute([$nik_ktp]);
        
        if ($check_stmt->rowCount() > 0) {
            $error = 'NIK KTP sudah terdaftar!';
        } else {
            // Handle upload foto KTP
            $foto_ktp = '';
            if (isset($_FILES['foto_ktp']) && $_FILES['foto_ktp']['error'] == 0) {
                $allowed_types = ['image/jpeg', 'image/jpg', 'image/png'];
                $max_size = 5 * 1024 * 1024; // 5MB
                
                if (in_array($_FILES['foto_ktp']['type'], $allowed_types) && $_FILES['foto_ktp']['size'] <= $max_size) {
                    $file_extension = pathinfo($_FILES['foto_ktp']['name'], PATHINFO_EXTENSION);
                    $foto_ktp = 'ktp_' . time() . '_' . $nik_ktp . '.' . $file_extension;
                    $upload_path = 'uploads/ktp/' . $foto_ktp;
                    
                    if (!move_uploaded_file($_FILES['foto_ktp']['tmp_name'], $upload_path)) {
                        $error = 'Gagal mengupload foto KTP!';
                    }
                } else {
                    $error = 'Format foto KTP tidak valid! Gunakan JPG/PNG maksimal 5MB.';
                }
            }
            
            if (empty($error)) {
                // Insert data pelanggan
                $query = "INSERT INTO customers (nama_lengkap, pekerjaan, alamat_lengkap, nomor_hp, email, nik_ktp, foto_ktp, created_by) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
                $stmt = $db->prepare($query);
                
                if ($stmt->execute([$nama_lengkap, $pekerjaan, $alamat_lengkap, $nomor_hp, $email, $nik_ktp, $foto_ktp, $_SESSION['user_id']])) {
                    // Log aktivitas
                    $log_query = "INSERT INTO activity_logs (user_id, action, description, table_name, record_id) VALUES (?, 'create', 'Menambah data pelanggan baru', 'customers', ?)";
                    $log_stmt = $db->prepare($log_query);
                    $log_stmt->execute([$_SESSION['user_id'], $db->lastInsertId()]);
                    
                    $success = 'Data pelanggan berhasil ditambahkan!';
                    // Reset form
                    $_POST = array();
                } else {
                    $error = 'Gagal menambahkan data pelanggan!';
                }
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tambah Pelanggan - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .sidebar .logo {
            padding: 1rem;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        .sidebar .logo i {
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.8);
            padding: 0.75rem 1rem;
            border-radius: 0.375rem;
            margin: 0.25rem 0.5rem;
        }
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background: rgba(255,255,255,0.1);
        }
        .main-content {
            background: #f8f9fa;
            min-height: 100vh;
        }
        .header {
            background: white;
            padding: 1rem 2rem;
            border-bottom: 1px solid #dee2e6;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
        }
        .form-card {
            background: white;
            border-radius: 0.5rem;
            padding: 2rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0">
                <div class="sidebar">
                    <div class="logo">
                        <i class="fas fa-wifi"></i>
                        <h6 class="mb-0"><?php echo APP_NAME; ?></h6>
                        <small><?php echo APP_COMPANY; ?></small>
                    </div>
                    <nav class="nav flex-column mt-3">
                        <a class="nav-link" href="dashboard.php">
                            <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                        </a>
                        <a class="nav-link" href="customers.php">
                            <i class="fas fa-users me-2"></i>Data Pelanggan
                        </a>
                        <a class="nav-link active" href="add_customer.php">
                            <i class="fas fa-user-plus me-2"></i>Tambah Pelanggan
                        </a>
                        <a class="nav-link" href="reports.php">
                            <i class="fas fa-chart-bar me-2"></i>Laporan
                        </a>
                        <a class="nav-link" href="logout.php">
                            <i class="fas fa-sign-out-alt me-2"></i>Logout
                        </a>
                    </nav>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-0">
                <div class="main-content">
                    <!-- Header -->
                    <div class="header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="mb-0">Tambah Data Pelanggan</h4>
                            <div class="d-flex align-items-center">
                                <span class="me-3">Selamat datang, <?php echo $_SESSION['full_name']; ?></span>
                                <span class="badge bg-primary"><?php echo ucfirst($_SESSION['user_role']); ?></span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Content -->
                    <div class="p-4">
                        <div class="row justify-content-center">
                            <div class="col-lg-8">
                                <div class="form-card">
                                    <?php if ($success): ?>
                                        <div class="alert alert-success" role="alert">
                                            <i class="fas fa-check-circle me-2"></i>
                                            <?php echo $success; ?>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($error): ?>
                                        <div class="alert alert-danger" role="alert">
                                            <i class="fas fa-exclamation-triangle me-2"></i>
                                            <?php echo $error; ?>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <form method="POST" enctype="multipart/form-data">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label for="nama_lengkap" class="form-label">
                                                    <i class="fas fa-user me-2"></i>Nama Lengkap *
                                                </label>
                                                <input type="text" class="form-control" id="nama_lengkap" name="nama_lengkap" 
                                                       value="<?php echo isset($_POST['nama_lengkap']) ? $_POST['nama_lengkap'] : ''; ?>" required>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="pekerjaan" class="form-label">
                                                    <i class="fas fa-briefcase me-2"></i>Pekerjaan
                                                </label>
                                                <input type="text" class="form-control" id="pekerjaan" name="pekerjaan" 
                                                       value="<?php echo isset($_POST['pekerjaan']) ? $_POST['pekerjaan'] : ''; ?>">
                                            </div>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="alamat_lengkap" class="form-label">
                                                <i class="fas fa-map-marker-alt me-2"></i>Alamat Lengkap *
                                            </label>
                                            <textarea class="form-control" id="alamat_lengkap" name="alamat_lengkap" rows="3" required><?php echo isset($_POST['alamat_lengkap']) ? $_POST['alamat_lengkap'] : ''; ?></textarea>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label for="nomor_hp" class="form-label">
                                                    <i class="fas fa-phone me-2"></i>Nomor HP *
                                                </label>
                                                <input type="tel" class="form-control" id="nomor_hp" name="nomor_hp" 
                                                       value="<?php echo isset($_POST['nomor_hp']) ? $_POST['nomor_hp'] : ''; ?>" required>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="email" class="form-label">
                                                    <i class="fas fa-envelope me-2"></i>Email
                                                </label>
                                                <input type="email" class="form-control" id="email" name="email" 
                                                       value="<?php echo isset($_POST['email']) ? $_POST['email'] : ''; ?>">
                                            </div>
                                        </div>
                                        
                                        <div class="mb-4">
                                            <label for="nik_ktp" class="form-label">
                                                <i class="fas fa-id-card me-2"></i>NIK KTP *
                                            </label>
                                            <input type="text" class="form-control" id="nik_ktp" name="nik_ktp" 
                                                   value="<?php echo isset($_POST['nik_ktp']) ? $_POST['nik_ktp'] : ''; ?>" 
                                                   maxlength="16" pattern="[0-9]{16}" required>
                                            <div class="form-text">NIK KTP harus 16 digit angka</div>
                                        </div>
                                        
                                        <div class="mb-4">
                                            <label for="foto_ktp" class="form-label">
                                                <i class="fas fa-camera me-2"></i>Foto KTP
                                            </label>
                                            <input type="file" class="form-control" id="foto_ktp" name="foto_ktp" 
                                                   accept="image/jpeg,image/jpg,image/png">
                                            <div class="form-text">
                                                <i class="fas fa-info-circle me-1"></i>
                                                Format: JPG/PNG, maksimal 5MB. Foto akan otomatis diresize.
                                            </div>
                                            <div id="foto-preview" class="mt-2" style="display: none;">
                                                <img id="preview-img" src="" alt="Preview Foto KTP" class="img-thumbnail" style="max-width: 200px; max-height: 150px;">
                                                <button type="button" class="btn btn-sm btn-outline-danger ms-2" onclick="removeFoto()">
                                                    <i class="fas fa-times me-1"></i>Hapus
                                                </button>
                                            </div>
                                        </div>
                                        
                                        <div class="d-flex justify-content-between">
                                            <a href="customers.php" class="btn btn-secondary">
                                                <i class="fas fa-arrow-left me-2"></i>Kembali
                                            </a>
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fas fa-save me-2"></i>Simpan Data
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Validasi NIK KTP hanya angka
        document.getElementById('nik_ktp').addEventListener('input', function(e) {
            this.value = this.value.replace(/[^0-9]/g, '');
        });
        
        // Validasi nomor HP hanya angka
        document.getElementById('nomor_hp').addEventListener('input', function(e) {
            this.value = this.value.replace(/[^0-9]/g, '');
        });
        
        // Preview foto KTP
        document.getElementById('foto_ktp').addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                // Validasi ukuran file (5MB)
                if (file.size > 5 * 1024 * 1024) {
                    alert('Ukuran file terlalu besar! Maksimal 5MB.');
                    this.value = '';
                    return;
                }
                
                // Validasi tipe file
                const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png'];
                if (!allowedTypes.includes(file.type)) {
                    alert('Format file tidak valid! Gunakan JPG atau PNG.');
                    this.value = '';
                    return;
                }
                
                // Tampilkan preview
                const reader = new FileReader();
                reader.onload = function(e) {
                    document.getElementById('preview-img').src = e.target.result;
                    document.getElementById('foto-preview').style.display = 'block';
                };
                reader.readAsDataURL(file);
            }
        });
        
        // Hapus foto
        function removeFoto() {
            document.getElementById('foto_ktp').value = '';
            document.getElementById('foto-preview').style.display = 'none';
        }
        
        // Validasi form sebelum submit
        document.querySelector('form').addEventListener('submit', function(e) {
            const fotoInput = document.getElementById('foto_ktp');
            if (fotoInput.files.length > 0) {
                const file = fotoInput.files[0];
                if (file.size > 5 * 1024 * 1024) {
                    e.preventDefault();
                    alert('Ukuran file foto KTP terlalu besar! Maksimal 5MB.');
                    return false;
                }
                if (!['image/jpeg', 'image/jpg', 'image/png'].includes(file.type)) {
                    e.preventDefault();
                    alert('Format file foto KTP tidak valid! Gunakan JPG atau PNG.');
                    return false;
                }
            }
        });
    </script>
</body>
</html>
