# 📋 Formulir Pendaftaran Internet - ENSIA

## ✅ **Form Baru: Desain Profesional dengan Tailwind CSS**

Formulir pendaftaran internet telah diperbarui dengan desain yang lebih profesional menggunakan Tailwind CSS dan AJAX untuk pengalaman pengguna yang lebih baik.

---

## 🎯 **Fitur Utama**

### **🎨 Desain Profesional:**
- **Tailwind CSS**: Framework CSS modern untuk styling yang konsisten
- **Google Fonts Inter**: Typography yang clean dan mudah dibaca
- **Responsive Design**: Tampilan optimal di semua device
- **Professional Layout**: Header dengan logo, footer dengan informasi lengkap

### **📝 Form Lengkap:**
- **Data Administratif**: Sektor, No Register, Tanggal
- **Data Pribadi**: Nama lengkap, nama panggilan, alamat KTP
- **Data Instalasi**: Alamat pemasangan, nomor identitas, pekerjaan
- **Kontak**: No HP 1, No HP 2
- **Upload KTP**: Upload foto KTP dengan preview
- **Paket Internet**: Pilihan 10mb, 15mb, 20mb, 30mb
- **Konfigurasi**: Jenis modem, nama WiFi, password
- **Data Teknis**: Status rumah, jarak, ID pelanggan
- **Pembayaran**: Biaya pendaftaran, status bayar

### **⚡ AJAX Integration:**
- **No Page Refresh**: Form submit tanpa reload halaman
- **Real-time Feedback**: Alert success/error langsung muncul
- **Loading Overlay**: Indikator loading saat proses
- **Form Reset**: Otomatis reset form setelah berhasil

---

## 🎨 **Tampilan Visual**

### **Header Section:**
- **Logo MAJUIN**: Branding yang konsisten
- **Powered By RSTN**: Partner branding
- **Customer Care**: Informasi kontak yang jelas

### **Form Layout:**
- **Grid System**: Layout responsive dengan grid
- **Color Scheme**: Blue (#3b82f6) sebagai primary color
- **Typography**: Font Inter untuk readability
- **Spacing**: Consistent padding dan margin

### **Form Elements:**
- **Custom Radio Buttons**: Styling yang menarik
- **Input Fields**: Consistent styling dengan focus states
- **File Upload**: Preview gambar KTP
- **Submit Button**: Hover effects dan loading states

---

## 🛠️ **Implementasi Teknis**

### **1. HTML Structure:**
```html
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Formulir Pendaftaran Internet - ENSIA</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen p-4">
    <div class="w-full max-w-4xl bg-white shadow-lg rounded-lg overflow-hidden">
        <!-- Header, Form, Footer -->
    </div>
</body>
</html>
```

### **2. CSS Customization:**
```css
/* Custom Radio Buttons */
.form-radio {
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
    display: inline-block;
    position: relative;
    background-color: #f9fafb;
    color: #374151;
    top: 5px;
    height: 1.5rem;
    width: 1.5rem;
    border: 1px solid #d1d5db;
    border-radius: 50%;
    cursor: pointer;
    margin-right: 0.5rem;
    outline: none;
}

.form-radio:checked {
    background-color: #3b82f6;
    border-color: #3b82f6;
}

.form-radio:checked::before {
    content: '';
    display: block;
    width: 0.75rem;
    height: 0.75rem;
    background-color: white;
    border-radius: 50%;
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
}
```

### **3. AJAX Form Handling:**
```javascript
// AJAX Form submission
document.getElementById('customerForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const paket = document.querySelector('input[name="paket"]:checked');
    if (!paket) {
        showAlert('Pilih paket internet terlebih dahulu!', 'error');
        return false;
    }
    
    // Show loading overlay
    document.getElementById('loadingOverlay').style.display = 'flex';
    
    // Create FormData
    const formData = new FormData(this);
    
    // Send AJAX request
    fetch('teknisi_add_customer_new.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showAlert(data.message, 'success');
            // Reset form
            document.getElementById('customerForm').reset();
            document.getElementById('foto-preview').style.display = 'none';
        } else {
            showAlert(data.message, 'error');
        }
    })
    .catch(error => {
        showAlert('Terjadi kesalahan: ' + error.message, 'error');
    })
    .finally(() => {
        // Hide loading overlay
        document.getElementById('loadingOverlay').style.display = 'none';
    });
});
```

### **4. PHP Backend:**
```php
// Handle AJAX form submission
if ($_POST && isset($_POST['ajax'])) {
    header('Content-Type: application/json');
    
    $nama_lengkap = sanitizeInput($_POST['nama_lengkap']);
    $nama_panggilan = sanitizeInput($_POST['nama_panggilan']);
    $alamat_ktp = sanitizeInput($_POST['alamat_ktp']);
    $alamat_pemasangan = sanitizeInput($_POST['alamat_pemasangan']);
    $nomor_identitas = sanitizeInput($_POST['nomor_identitas']);
    $pekerjaan = sanitizeInput($_POST['pekerjaan']);
    $no_hp1 = sanitizeInput($_POST['no_hp1']);
    $no_hp2 = sanitizeInput($_POST['no_hp2']);
    $paket = sanitizeInput($_POST['paket']);
    $jenis_modem = sanitizeInput($_POST['jenis_modem']);
    $nama_wifi = sanitizeInput($_POST['nama_wifi']);
    $password = sanitizeInput($_POST['password']);
    $status_rumah = sanitizeInput($_POST['status_rumah']);
    $jarak = sanitizeInput($_POST['jarak']);
    $id_pelanggan = sanitizeInput($_POST['id_pelanggan']);
    $biaya_pendaftaran = sanitizeInput($_POST['biaya_pendaftaran']);
    $status_bayar = sanitizeInput($_POST['status_bayar']);
    $sektor = sanitizeInput($_POST['sektor']);
    $no_register = sanitizeInput($_POST['no_register']);
    $tanggal = sanitizeInput($_POST['tanggal']);
    
    $response = ['success' => false, 'message' => ''];
    
    // Process form data and save to database
    // Return JSON response
    echo json_encode($response);
    exit;
}
```

---

## 📊 **Data Mapping**

### **Database Integration:**
- **nama_lengkap** → customers.nama_lengkap
- **pekerjaan** → customers.pekerjaan
- **alamat_pemasangan** → customers.alamat_lengkap
- **no_hp1** → customers.nomor_hp
- **nomor_identitas** → customers.nik_ktp
- **paket** → customers.paket_internet
- **Additional data** → customers.catatan_instalasi

### **Paket Pricing:**
- **10 Mbps** → Rp 150.000/bulan
- **15 Mbps** → Rp 200.000/bulan
- **20 Mbps** → Rp 250.000/bulan
- **30 Mbps** → Rp 350.000/bulan

---

## 🧪 **Test & Demo**

### **URL Demo:**
- **Demo Form**: `http://localhost:8080/demo_teknisi_add_customer_new.php`
- **Main Form**: `http://localhost:8080/teknisi_add_customer_new.php` (login required)

### **Data Sample:**
- **Nama**: Budi Santoso
- **Panggilan**: Budi
- **Alamat**: Jl. Merdeka No. 123, Sukabumi
- **NIK**: 3201234567890123
- **HP**: 081234567897
- **Paket**: 15 Mbps
- **Modem**: TP-Link Archer C6
- **WiFi**: MAJUIN-BUDI

---

## 🎯 **User Experience**

### **Form Workflow:**
1. **Teknisi Login** sebagai teknisi
2. **Akses Menu** "Tambah Pelanggan"
3. **Isi Form** dengan data lengkap
4. **Upload KTP** dengan preview
5. **Pilih Paket** internet
6. **Submit Form** via AJAX
7. **Real-time Feedback** success/error
8. **Form Reset** otomatis

### **Visual Feedback:**
- **Loading Overlay**: Saat proses submit
- **Success Alert**: Konfirmasi berhasil
- **Error Alert**: Pesan error yang jelas
- **Form Validation**: Validasi real-time

---

## 🔒 **Keamanan & Validasi**

### **Client-side Validation:**
- Required field validation
- File type validation (JPG/PNG)
- File size validation (max 5MB)
- Paket selection validation

### **Server-side Validation:**
- Input sanitization
- File upload security
- Database validation
- SQL injection protection

---

## 📱 **Responsive Design**

### **Breakpoints:**
- **Mobile**: 320px+ (single column)
- **Tablet**: 768px+ (two column)
- **Desktop**: 1024px+ (multi column)

### **Grid System:**
- **Grid-cols-1**: Mobile layout
- **md:grid-cols-2**: Tablet layout
- **md:grid-cols-12**: Desktop layout

---

## ✅ **Status: SELESAI**

**Formulir Pendaftaran Internet telah berhasil diperbarui!**

**Fitur yang tersedia:**
- ✅ Desain profesional dengan Tailwind CSS
- ✅ Form lengkap dengan semua field
- ✅ AJAX integration tanpa refresh
- ✅ Upload foto KTP dengan preview
- ✅ Pilihan paket internet (4 pilihan)
- ✅ Responsive design
- ✅ Real-time validation
- ✅ Loading states
- ✅ Professional branding

---

## 🔗 **Akses Demo**

- **Demo Form**: http://localhost:8080/demo_teknisi_add_customer_new.php
- **Main Form**: http://localhost:8080/teknisi_add_customer_new.php (login required)

**Formulir pendaftaran internet sekarang memiliki desain yang lebih profesional dan user-friendly!** 🎉

**Developed by Amiruloh untuk Tugas Akhir D3 Manajemen Informatika AMIK CBI Sukabumi**
