<?php
require_once 'config/config.php';
requireRole(['admin', 'supervisor', 'teknisi']);

$database = new Database();
$db = $database->getConnection();

$customer_id = (int)($_GET['id'] ?? 0);

if (!$customer_id) {
    header('Location: dashboard.php');
    exit();
}

// Query data pelanggan lengkap
$query = "SELECT c.*, u.full_name as created_by_name, 
          i.kabel_meter, i.latitude, i.longitude, i.alamat_instalasi, i.catatan, i.tanggal_instalasi, i.status as installation_status,
          u2.full_name as teknisi_name
          FROM customers c 
          LEFT JOIN users u ON c.created_by = u.id 
          LEFT JOIN installations i ON c.id = i.customer_id
          LEFT JOIN users u2 ON i.teknisi_id = u2.id
          WHERE c.id = ?";
$stmt = $db->prepare($query);
$stmt->execute([$customer_id]);
$customer = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$customer) {
    header('Location: dashboard.php');
    exit();
}

// Query log aktivitas
$log_query = "SELECT al.*, u.full_name as user_name 
              FROM activity_logs al 
              LEFT JOIN users u ON al.user_id = u.id 
              WHERE al.table_name = 'customers' AND al.record_id = ? 
              ORDER BY al.created_at DESC";
$log_stmt = $db->prepare($log_query);
$log_stmt->execute([$customer_id]);
$logs = $log_stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Pelanggan - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .sidebar .logo {
            padding: 1rem;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        .sidebar .logo i {
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.8);
            padding: 0.75rem 1rem;
            border-radius: 0.375rem;
            margin: 0.25rem 0.5rem;
        }
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background: rgba(255,255,255,0.1);
        }
        .main-content {
            background: #f8f9fa;
            min-height: 100vh;
        }
        .header {
            background: white;
            padding: 1rem 2rem;
            border-bottom: 1px solid #dee2e6;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
        }
        .detail-card {
            background: white;
            border-radius: 0.5rem;
            padding: 2rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
            margin-bottom: 1.5rem;
        }
        .info-row {
            border-bottom: 1px solid #f8f9fa;
            padding: 0.75rem 0;
        }
        .info-row:last-child {
            border-bottom: none;
        }
        .info-label {
            font-weight: 600;
            color: #495057;
            width: 200px;
        }
        .status-badge {
            font-size: 0.875rem;
        }
        .map-container {
            height: 300px;
            border-radius: 0.5rem;
            overflow: hidden;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0">
                <div class="sidebar">
                    <div class="logo">
                        <i class="fas fa-wifi"></i>
                        <h6 class="mb-0"><?php echo APP_NAME; ?></h6>
                        <small><?php echo APP_COMPANY; ?></small>
                    </div>
                    <nav class="nav flex-column mt-3">
                        <a class="nav-link" href="dashboard.php">
                            <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                        </a>
                        <?php if ($_SESSION['user_role'] == 'admin'): ?>
                        <a class="nav-link" href="customers.php">
                            <i class="fas fa-users me-2"></i>Data Pelanggan
                        </a>
                        <a class="nav-link" href="add_customer.php">
                            <i class="fas fa-user-plus me-2"></i>Tambah Pelanggan
                        </a>
                        <a class="nav-link" href="reports.php">
                            <i class="fas fa-chart-bar me-2"></i>Laporan
                        </a>
                        <?php endif; ?>
                        <?php if ($_SESSION['user_role'] == 'supervisor'): ?>
                        <a class="nav-link" href="approvals.php">
                            <i class="fas fa-check-circle me-2"></i>Persetujuan
                        </a>
                        <?php endif; ?>
                        <?php if ($_SESSION['user_role'] == 'teknisi'): ?>
                        <a class="nav-link" href="installations.php">
                            <i class="fas fa-tools me-2"></i>Instalasi
                        </a>
                        <?php endif; ?>
                        <a class="nav-link" href="logout.php">
                            <i class="fas fa-sign-out-alt me-2"></i>Logout
                        </a>
                    </nav>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-0">
                <div class="main-content">
                    <!-- Header -->
                    <div class="header">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="d-flex align-items-center">
                                <a href="javascript:history.back()" class="btn btn-outline-secondary me-3">
                                    <i class="fas fa-arrow-left me-2"></i>Kembali
                                </a>
                                <h4 class="mb-0">Detail Pelanggan</h4>
                            </div>
                            <div class="d-flex align-items-center">
                                <a href="customer_print.php?id=<?php echo $customer['id']; ?>" 
                                   class="btn btn-success me-2" target="_blank">
                                    <i class="fas fa-print me-2"></i>Print PDF
                                </a>
                                <span class="me-3">Selamat datang, <?php echo $_SESSION['full_name']; ?></span>
                                <span class="badge bg-primary"><?php echo ucfirst($_SESSION['user_role']); ?></span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Content -->
                    <div class="p-4">
                        <!-- Data Pelanggan -->
                        <div class="detail-card">
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <h5 class="mb-0">Informasi Pelanggan</h5>
                                <?php
                                $status_class = '';
                                $status_text = '';
                                switch ($customer['status']) {
                                    case 'pending':
                                        $status_class = 'warning';
                                        $status_text = 'Pending';
                                        break;
                                    case 'approved':
                                        $status_class = 'info';
                                        $status_text = 'Approved';
                                        break;
                                    case 'installed':
                                        $status_class = 'success';
                                        $status_text = 'Installed';
                                        break;
                                    case 'cancelled':
                                        $status_class = 'danger';
                                        $status_text = 'Cancelled';
                                        break;
                                    case 'rejected':
                                        $status_class = 'secondary';
                                        $status_text = 'Rejected';
                                        break;
                                }
                                ?>
                                <span class="badge bg-<?php echo $status_class; ?> status-badge fs-6">
                                    <?php echo $status_text; ?>
                                </span>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="info-row d-flex">
                                        <span class="info-label">Nama Lengkap:</span>
                                        <span><?php echo $customer['nama_lengkap']; ?></span>
                                    </div>
                                    <div class="info-row d-flex">
                                        <span class="info-label">Pekerjaan:</span>
                                        <span><?php echo $customer['pekerjaan'] ?: '-'; ?></span>
                                    </div>
                                    <div class="info-row d-flex">
                                        <span class="info-label">Nomor HP:</span>
                                        <span><?php echo $customer['nomor_hp']; ?></span>
                                    </div>
                                    <div class="info-row d-flex">
                                        <span class="info-label">Email:</span>
                                        <span><?php echo $customer['email'] ?: '-'; ?></span>
                                    </div>
                                    <div class="info-row d-flex">
                                        <span class="info-label">NIK KTP:</span>
                                        <span><?php echo $customer['nik_ktp']; ?></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="info-row d-flex">
                                        <span class="info-label">Dibuat Oleh:</span>
                                        <span><?php echo $customer['created_by_name']; ?></span>
                                    </div>
                                    <div class="info-row d-flex">
                                        <span class="info-label">Tanggal Input:</span>
                                        <span><?php echo formatDateTime($customer['created_at']); ?></span>
                                    </div>
                                    <?php if ($customer['approved_at']): ?>
                                    <div class="info-row d-flex">
                                        <span class="info-label">Tanggal Disetujui:</span>
                                        <span><?php echo formatDateTime($customer['approved_at']); ?></span>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="info-row">
                                <span class="info-label">Alamat Lengkap:</span>
                                <div class="mt-2">
                                    <?php echo nl2br($customer['alamat_lengkap']); ?>
                                </div>
                            </div>
                            
                            <!-- Foto KTP -->
                            <?php if (!empty($customer['foto_ktp'])): ?>
                                <div class="info-row">
                                    <span class="info-label">Foto KTP:</span>
                                    <div class="mt-2">
                                        <img src="uploads/ktp/<?php echo $customer['foto_ktp']; ?>" 
                                             alt="Foto KTP" class="img-thumbnail" 
                                             style="max-width: 200px; max-height: 150px; cursor: pointer;"
                                             data-bs-toggle="modal" data-bs-target="#photoModal">
                                        <div class="mt-2">
                                            <small class="text-muted">Klik untuk melihat dalam ukuran penuh</small>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <!-- Data Instalasi -->
                        <?php if ($customer['kabel_meter'] || $customer['latitude'] || $customer['longitude']): ?>
                        <div class="detail-card">
                            <h5 class="mb-4">Data Instalasi</h5>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="info-row d-flex">
                                        <span class="info-label">Status Instalasi:</span>
                                        <span>
                                            <?php
                                            $inst_status_class = '';
                                            $inst_status_text = '';
                                            switch ($customer['installation_status']) {
                                                case 'assigned':
                                                    $inst_status_class = 'warning';
                                                    $inst_status_text = 'Ditugaskan';
                                                    break;
                                                case 'in_progress':
                                                    $inst_status_class = 'info';
                                                    $inst_status_text = 'Sedang Berlangsung';
                                                    break;
                                                case 'completed':
                                                    $inst_status_class = 'success';
                                                    $inst_status_text = 'Selesai';
                                                    break;
                                                case 'failed':
                                                    $inst_status_class = 'danger';
                                                    $inst_status_text = 'Gagal';
                                                    break;
                                            }
                                            ?>
                                            <span class="badge bg-<?php echo $inst_status_class; ?>">
                                                <?php echo $inst_status_text; ?>
                                            </span>
                                        </span>
                                    </div>
                                    <div class="info-row d-flex">
                                        <span class="info-label">Panjang Kabel:</span>
                                        <span><?php echo $customer['kabel_meter'] ? $customer['kabel_meter'] . ' meter' : '-'; ?></span>
                                    </div>
                                    <div class="info-row d-flex">
                                        <span class="info-label">Teknisi:</span>
                                        <span><?php echo $customer['teknisi_name'] ?: '-'; ?></span>
                                    </div>
                                    <div class="info-row d-flex">
                                        <span class="info-label">Tanggal Instalasi:</span>
                                        <span><?php echo $customer['tanggal_instalasi'] ? formatDate($customer['tanggal_instalasi']) : '-'; ?></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="info-row d-flex">
                                        <span class="info-label">Koordinat:</span>
                                        <span>
                                            <?php if ($customer['latitude'] && $customer['longitude']): ?>
                                                <?php echo $customer['latitude'] . ', ' . $customer['longitude']; ?>
                                                <a href="https://www.google.com/maps?q=<?php echo $customer['latitude']; ?>,<?php echo $customer['longitude']; ?>" 
                                                   target="_blank" class="btn btn-sm btn-outline-info ms-2">
                                                    <i class="fas fa-map-marker-alt me-1"></i>Lihat Peta
                                                </a>
                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            
                            <?php if ($customer['alamat_instalasi']): ?>
                            <div class="info-row">
                                <span class="info-label">Alamat Instalasi:</span>
                                <div class="mt-2">
                                    <?php echo nl2br($customer['alamat_instalasi']); ?>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <?php if ($customer['catatan']): ?>
                            <div class="info-row">
                                <span class="info-label">Catatan Instalasi:</span>
                                <div class="mt-2">
                                    <?php echo nl2br($customer['catatan']); ?>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <!-- Map -->
                            <?php if ($customer['latitude'] && $customer['longitude']): ?>
                            <div class="info-row">
                                <span class="info-label">Peta Lokasi:</span>
                                <div class="mt-2">
                                    <div class="map-container">
                                        <iframe 
                                            width="100%" 
                                            height="100%" 
                                            frameborder="0" 
                                            style="border:0"
                                            src="https://www.google.com/maps/embed/v1/place?key=YOUR_API_KEY&q=<?php echo $customer['latitude']; ?>,<?php echo $customer['longitude']; ?>&zoom=15"
                                            allowfullscreen>
                                        </iframe>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Log Aktivitas -->
                        <?php if (!empty($logs)): ?>
                        <div class="detail-card">
                            <h5 class="mb-4">Log Aktivitas</h5>
                            
                            <div class="timeline">
                                <?php foreach ($logs as $log): ?>
                                <div class="timeline-item d-flex mb-3">
                                    <div class="timeline-marker bg-primary rounded-circle me-3" style="width: 12px; height: 12px; margin-top: 6px;"></div>
                                    <div class="timeline-content">
                                        <div class="d-flex justify-content-between">
                                            <h6 class="mb-1"><?php echo ucfirst($log['action']); ?></h6>
                                            <small class="text-muted"><?php echo formatDateTime($log['created_at']); ?></small>
                                        </div>
                                        <p class="mb-1 text-muted"><?php echo $log['description']; ?></p>
                                        <small class="text-muted">Oleh: <?php echo $log['user_name']; ?></small>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Modal Foto KTP -->
    <?php if (!empty($customer['foto_ktp'])): ?>
        <div class="modal fade" id="photoModal" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Foto KTP - <?php echo $customer['nama_lengkap']; ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body text-center">
                        <img src="uploads/ktp/<?php echo $customer['foto_ktp']; ?>" 
                             alt="Foto KTP" class="img-fluid" style="max-height: 70vh;">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
