<?php
// Konfigurasi Aplikasi ENSIA
// Engineer On Site App (ENSIA) PT Maintek Juara Intisolusi

// Start session
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Konfigurasi aplikasi
define('APP_NAME', 'Engineer On Site App (ENSIA)');
define('APP_COMPANY', 'PT Maintek Juara Intisolusi');
define('APP_DEVELOPER', 'Amiruloh');
define('APP_PURPOSE', 'Tugas Akhir D3 Manajemen Informatika AMIK CBI Sukabumi');

// Konfigurasi path
define('BASE_URL', 'http://localhost/ensia1/');
define('ASSETS_PATH', BASE_URL . 'assets/');
define('UPLOADS_PATH', 'uploads/');

// Konfigurasi database
require_once 'database.php';

// Fungsi helper
function isLoggedIn() {
    return isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
}

function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: login.php');
        exit();
    }
}

function requireRole($roles) {
    requireLogin();
    if (!in_array($_SESSION['user_role'], $roles)) {
        header('Location: unauthorized.php');
        exit();
    }
}

function sanitizeInput($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

function formatDate($date) {
    return date('d/m/Y', strtotime($date));
}

function formatDateTime($datetime) {
    return date('d/m/Y H:i', strtotime($datetime));
}

// Autoload classes
spl_autoload_register(function ($class_name) {
    $file = 'classes/' . $class_name . '.php';
    if (file_exists($file)) {
        require_once $file;
    }
});
?>
