<?php
require_once 'config/database.php';

$database = new Database();
$db = $database->getConnection();

echo "Testing Assign Technician (Available Customer)...\n";

try {
    // Test data - available customer
    $customer_id = 11; // asd
    $teknisi_id = 3; // Teknisi 1
    
    // Check if customer already has installation
    $check_query = "SELECT id FROM installations WHERE customer_id = ?";
    $check_stmt = $db->prepare($check_query);
    $check_stmt->execute([$customer_id]);
    
    if ($check_stmt->rowCount() > 0) {
        echo "❌ Pelanggan ini sudah memiliki instalasi!\n";
    } else {
        // Create installation assignment
        $query = "INSERT INTO installations (customer_id, teknisi_id, kabel_meter, status) VALUES (?, ?, 0, 'assigned')";
        $stmt = $db->prepare($query);
        
        if ($stmt->execute([$customer_id, $teknisi_id])) {
            echo "✓ Teknisi berhasil ditugaskan!\n";
            echo "Installation ID: " . $db->lastInsertId() . "\n";
            echo "Customer ID: $customer_id\n";
            echo "Teknisi ID: $teknisi_id\n";
            echo "Status: assigned\n";
        } else {
            echo "❌ Gagal menugaskan teknisi!\n";
        }
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>




