<?php
require_once 'config/database.php';

$database = new Database();
$db = $database->getConnection();

echo "Testing Add Technician...\n";

try {
    // Test data
    $nama_teknisi = "Test Teknisi";
    $nomor_hp = "081234567999";
    $email = "test.teknisi@majuin.co.id";
    $username = "test_teknisi";
    $password = password_hash("password123", PASSWORD_DEFAULT);
    $created_by = 1; // Admin user ID
    
    // Check if username or email already exists
    $check_query = "SELECT id FROM users WHERE username = ? OR email = ?";
    $check_stmt = $db->prepare($check_query);
    $check_stmt->execute([$username, $email]);
    
    if ($check_stmt->rowCount() > 0) {
        echo "❌ Username atau email sudah digunakan!\n";
    } else {
        // Insert new technician
        $query = "INSERT INTO users (username, email, password, full_name, role, nomor_hp, created_by) VALUES (?, ?, ?, ?, 'teknisi', ?, ?)";
        $stmt = $db->prepare($query);
        
        if ($stmt->execute([$username, $email, $password, $nama_teknisi, $nomor_hp, $created_by])) {
            echo "✓ Technician added successfully!\n";
            echo "ID: " . $db->lastInsertId() . "\n";
            echo "Name: $nama_teknisi\n";
            echo "Username: $username\n";
            echo "Email: $email\n";
            echo "Phone: $nomor_hp\n";
        } else {
            echo "❌ Failed to add technician!\n";
        }
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>

