<?php
require_once 'config/config.php';
requireRole(['teknisi']);

$database = new Database();
$db = $database->getConnection();

// Handle AJAX form submission
if ($_POST && isset($_POST['ajax'])) {
    header('Content-Type: application/json');
    
    $nama_lengkap = sanitizeInput($_POST['nama_lengkap']);
    $nama_panggilan = sanitizeInput($_POST['nama_panggilan']);
    $alamat_ktp = sanitizeInput($_POST['alamat_ktp']);
    $alamat_pemasangan = sanitizeInput($_POST['alamat_pemasangan']);
    $nomor_identitas = sanitizeInput($_POST['nomor_identitas']);
    $pekerjaan = sanitizeInput($_POST['pekerjaan']);
    $no_hp1 = sanitizeInput($_POST['no_hp1']);
    $no_hp2 = sanitizeInput($_POST['no_hp2']);
    $paket = sanitizeInput($_POST['paket']);
    $jenis_modem = sanitizeInput($_POST['jenis_modem']);
    $nama_wifi = sanitizeInput($_POST['nama_wifi']);
    $password = sanitizeInput($_POST['password']);
    $status_rumah = sanitizeInput($_POST['status_rumah']);
    $jarak = sanitizeInput($_POST['jarak']);
    $id_pelanggan = sanitizeInput($_POST['id_pelanggan']);
    $biaya_pendaftaran = sanitizeInput($_POST['biaya_pendaftaran']);
    $status_bayar = sanitizeInput($_POST['status_bayar']);
    $sektor = sanitizeInput($_POST['sektor']);
    $no_register = sanitizeInput($_POST['no_register']);
    $tanggal = sanitizeInput($_POST['tanggal']);
    
    $response = ['success' => false, 'message' => ''];
    
    // Handle upload foto KTP
    $foto_ktp = '';
    if (isset($_FILES['foto_ktp']) && $_FILES['foto_ktp']['error'] == 0) {
        $allowed_types = ['image/jpeg', 'image/jpg', 'image/png'];
        $max_size = 5 * 1024 * 1024; // 5MB
        
        if (in_array($_FILES['foto_ktp']['type'], $allowed_types) && $_FILES['foto_ktp']['size'] <= $max_size) {
            $file_extension = pathinfo($_FILES['foto_ktp']['name'], PATHINFO_EXTENSION);
            $foto_ktp = 'ktp_' . time() . '_' . $nomor_identitas . '.' . $file_extension;
            $upload_path = 'uploads/ktp/' . $foto_ktp;
            
            if (!move_uploaded_file($_FILES['foto_ktp']['tmp_name'], $upload_path)) {
                $response['message'] = 'Gagal mengupload foto KTP!';
                echo json_encode($response);
                exit;
            }
        } else {
            $response['message'] = 'Format foto KTP tidak valid! Gunakan JPG/PNG maksimal 5MB.';
            echo json_encode($response);
            exit;
        }
    }
    
    try {
        // Insert customer data
        $query = "INSERT INTO customers (nama_lengkap, pekerjaan, alamat_lengkap, nomor_hp, email, nik_ktp, foto_ktp, paket_internet, harga_paket, catatan_instalasi, created_by, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'pending')";
        $stmt = $db->prepare($query);
        
        // Map new fields to existing database structure
        $alamat_lengkap = $alamat_pemasangan; // Use alamat_pemasangan as alamat_lengkap
        $nomor_hp = $no_hp1; // Use no_hp1 as nomor_hp
        $email = $nama_panggilan . '@email.com'; // Generate email from nama_panggilan
        $nik_ktp = $nomor_identitas; // Use nomor_identitas as nik_ktp
        $paket_internet = $paket . ' Mbps'; // Convert paket to string
        $harga_paket = 0; // Will be calculated based on paket
        $catatan_instalasi = "Sektor: $sektor, No Register: $no_register, Tanggal: $tanggal, Status Rumah: $status_rumah, Jarak: $jarak, ID Pelanggan: $id_pelanggan, Biaya: $biaya_pendaftaran, Status Bayar: $status_bayar, Modem: $jenis_modem, WiFi: $nama_wifi, HP2: $no_hp2";
        
        // Calculate harga based on paket
        switch($paket) {
            case '10': $harga_paket = 150000; break;
            case '15': $harga_paket = 200000; break;
            case '20': $harga_paket = 250000; break;
            case '30': $harga_paket = 350000; break;
            default: $harga_paket = 150000;
        }
        
        if ($stmt->execute([$nama_lengkap, $pekerjaan, $alamat_lengkap, $nomor_hp, $email, $nik_ktp, $foto_ktp, $paket_internet, $harga_paket, $catatan_instalasi, $_SESSION['user_id']])) {
            $response['success'] = true;
            $response['message'] = 'Data pelanggan berhasil ditambahkan! Status: Pending (menunggu persetujuan supervisor)';
            
            // Log activity
            $log_query = "INSERT INTO activity_logs (user_id, action, description, table_name, record_id) VALUES (?, 'create', 'Menambahkan data pelanggan baru', 'customers', ?)";
            $log_stmt = $db->prepare($log_query);
            $log_stmt->execute([$_SESSION['user_id'], $db->lastInsertId()]);
        } else {
            $response['message'] = 'Gagal menambahkan data pelanggan!';
        }
    } catch (Exception $e) {
        $response['message'] = 'Error: ' . $e->getMessage();
    }
    
    echo json_encode($response);
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Formulir Pendaftaran Internet - ENSIA</title>
    <!-- Memuat Tailwind CSS untuk styling -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Memuat Google Fonts: Inter -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        /* Menggunakan font Inter sebagai default */
        body {
            font-family: 'Inter', sans-serif;
        }
        /* Style kustom untuk radio button agar lebih menarik */
        .form-radio {
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            display: inline-block;
            position: relative;
            background-color: #f9fafb;
            color: #374151;
            top: 5px;
            height: 1.5rem;
            width: 1.5rem;
            border: 1px solid #d1d5db;
            border-radius: 50%;
            cursor: pointer;
            margin-right: 0.5rem;
            outline: none;
        }
        .form-radio:checked {
            background-color: #3b82f6;
            border-color: #3b82f6;
        }
        .form-radio:checked::before {
            content: '';
            display: block;
            width: 0.75rem;
            height: 0.75rem;
            background-color: white;
            border-radius: 50%;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }
        .form-radio:hover {
            border-color: #9ca3af;
        }
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }
        .loading-spinner {
            background: white;
            padding: 2rem;
            border-radius: 10px;
            text-align: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
        }
        .spinner-border {
            width: 3rem;
            height: 3rem;
            border-width: 0.3em;
        }
    </style>
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen p-4">

    <div class="w-full max-w-4xl bg-white shadow-lg rounded-lg overflow-hidden">
        <!-- Bagian Header -->
        <header class="p-4 grid grid-cols-3 items-center border-b">
            <div class="flex items-center">
                <!-- Ganti '#' dengan path logo Anda -->
                <img src="https://placehold.co/40x40/0284C7/FFFFFF?text=M" alt="Logo Majuin" class="h-10 w-10 mr-2">
                <div>
                    <h1 class="font-bold text-lg text-blue-700">MAJUIN</h1>
                    <p class="text-xs text-gray-600">PT Maintek Juara Inti Solusi</p>
                </div>
            </div>
            <div class="text-center">
                 <p class="text-sm font-semibold">Powered By:</p>
                 <!-- Ganti '#' dengan path logo Anda -->
                 <img src="https://placehold.co/120x40/FBBF24/000000?text=RSTN+Net" alt="Logo RSTN" class="h-10 mx-auto">
            </div>
            <div class="text-right">
                <div class="bg-blue-700 text-white p-3 rounded-lg inline-block">
                    <p class="text-sm font-semibold">Customer Care</p>
                    <p class="text-lg font-bold">(MAJUIN)</p>
                    <p class="text-xl font-bold">0817 228 297</p>
                </div>
            </div>
        </header>

        <!-- Bagian Judul Formulir -->
        <div class="bg-yellow-400 p-3 my-4 mx-4 rounded-md">
            <h2 class="text-center text-2xl font-bold text-gray-800">Formulir Pendaftaran Internet</h2>
        </div>

        <!-- Alert Area -->
        <div id="alertArea" class="mx-4"></div>

        <!-- Bagian Formulir Utama -->
        <main class="p-6">
            <form id="customerForm" action="#" method="POST" enctype="multipart/form-data">
                <input type="hidden" name="ajax" value="1">
                
                <!-- Baris Pertama: Sektor, No Register, Tanggal -->
                <div class="grid grid-cols-1 md:grid-cols-12 gap-4 mb-4 items-center">
                    <div class="md:col-span-4 flex items-center">
                        <label for="sektor" class="w-1/3 font-semibold text-gray-700">Sektor</label>
                        <input type="text" id="sektor" name="sektor" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" required>
                    </div>
                    <div class="md:col-span-4 flex items-center">
                        <label for="no_register" class="w-1/3 font-semibold text-gray-700">No Register</label>
                        <input type="text" id="no_register" name="no_register" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" required>
                    </div>
                    <div class="md:col-span-4 flex items-center">
                        <label for="tanggal" class="font-semibold text-gray-700 mr-2">Tanggal</label>
                        <input type="date" id="tanggal" name="tanggal" class="bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" required>
                    </div>
                </div>

                <!-- Baris Nama Lengkap & Panggilan -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div class="flex items-center">
                        <label for="nama_lengkap" class="w-1/4 font-semibold text-gray-700">Nama Lengkap</label>
                        <input type="text" id="nama_lengkap" name="nama_lengkap" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" required>
                    </div>
                    <div class="flex items-center">
                        <label for="nama_panggilan" class="w-1/4 font-semibold text-gray-700">Nama Panggilan</label>
                        <input type="text" id="nama_panggilan" name="nama_panggilan" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" required>
                    </div>
                </div>

                <!-- Input Lainnya -->
                <div class="space-y-4">
                    <div class="flex items-center">
                        <label for="alamat_ktp" class="w-[16.66%] font-semibold text-gray-700">Alamat KTP</label>
                        <input type="text" id="alamat_ktp" name="alamat_ktp" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" required>
                    </div>
                    <div class="flex items-center">
                        <label for="alamat_pemasangan" class="w-[16.66%] font-semibold text-gray-700">Alamat Pemasangan</label>
                        <input type="text" id="alamat_pemasangan" name="alamat_pemasangan" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" required>
                    </div>
                     <div class="flex items-center">
                        <label for="nomor_identitas" class="w-[16.66%] font-semibold text-gray-700">Nomor Identitas</label>
                        <input type="text" id="nomor_identitas" name="nomor_identitas" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" required>
                    </div>
                     <div class="flex items-center">
                        <label for="pekerjaan" class="w-[16.66%] font-semibold text-gray-700">Pekerjaan</label>
                        <input type="text" id="pekerjaan" name="pekerjaan" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" required>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="flex items-center">
                            <label for="no_hp1" class="w-1/4 font-semibold text-gray-700">No Hp 1</label>
                            <input type="tel" id="no_hp1" name="no_hp1" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" required>
                        </div>
                        <div class="flex items-center">
                            <label for="no_hp2" class="w-1/4 font-semibold text-gray-700">No Hp 2</label>
                            <input type="tel" id="no_hp2" name="no_hp2" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5">
                        </div>
                    </div>

                    <!-- Upload Foto KTP -->
                    <div class="flex items-center">
                        <label for="foto_ktp" class="w-[16.66%] font-semibold text-gray-700">Foto KTP</label>
                        <div class="flex-1">
                            <input type="file" id="foto_ktp" name="foto_ktp" accept="image/jpeg,image/jpg,image/png" class="bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5">
                            <div class="text-xs text-gray-500 mt-1">Format: JPG/PNG, maksimal 5MB</div>
                            <div id="foto-preview" class="mt-2" style="display: none;">
                                <img id="preview-img" src="" alt="Preview Foto KTP" class="w-32 h-24 object-cover rounded border">
                                <button type="button" class="ml-2 text-red-500 text-sm" onclick="removeFoto()">Hapus</button>
                            </div>
                        </div>
                    </div>

                    <!-- Pilihan Paket -->
                    <div class="flex items-center">
                        <label class="w-[16.66%] font-semibold text-gray-700">Pilihan Paket</label>
                        <div class="flex-1 flex items-center space-x-6">
                            <label class="flex items-center"><input type="radio" name="paket" value="10" class="form-radio" required> 10 mb</label>
                            <label class="flex items-center"><input type="radio" name="paket" value="15" class="form-radio"> 15 mb</label>
                            <label class="flex items-center"><input type="radio" name="paket" value="20" class="form-radio"> 20 mb</label>
                            <label class="flex items-center"><input type="radio" name="paket" value="30" class="form-radio"> 30 mb</label>
                        </div>
                         <label for="jenis_modem" class="font-semibold text-gray-700 ml-4 mr-2">Jenis Modem</label>
                         <input type="text" id="jenis_modem" name="jenis_modem" class="w-1/4 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5">
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="flex items-center">
                            <label for="nama_wifi" class="w-1/4 font-semibold text-gray-700">Nama Wifi</label>
                            <input type="text" id="nama_wifi" name="nama_wifi" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5">
                        </div>
                        <div class="flex items-center">
                            <label for="password" class="w-1/4 font-semibold text-gray-700">Password</label>
                            <input type="password" id="password" name="password" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" placeholder="Minimal 8 karakter">
                        </div>
                    </div>
                     <div class="grid grid-cols-1 md:grid-cols-12 gap-4 items-center">
                        <div class="md:col-span-4 flex items-center">
                           <label for="status_rumah" class="w-1/2 font-semibold text-gray-700">Status Rumah</label>
                           <input type="text" id="status_rumah" name="status_rumah" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5">
                        </div>
                         <div class="md:col-span-4 flex items-center">
                           <label for="jarak" class="w-1/3 font-semibold text-gray-700">Jarak</label>
                           <input type="text" id="jarak" name="jarak" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5">
                        </div>
                        <div class="md:col-span-4 flex items-center">
                           <label for="id_pelanggan" class="w-1/2 font-semibold text-gray-700">ID Pelanggan</label>
                           <input type="text" id="id_pelanggan" name="id_pelanggan" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5">
                        </div>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="flex items-center">
                            <label for="biaya_pendaftaran" class="w-1/2 font-semibold text-gray-700">Biaya Pendaftaran</label>
                            <input type="text" id="biaya_pendaftaran" name="biaya_pendaftaran" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5">
                        </div>
                        <div class="flex items-center">
                           <label for="status_bayar" class="w-1/3 font-semibold text-gray-700">Status Bayar</label>
                            <input type="text" id="status_bayar" name="status_bayar" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5">
                        </div>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="text-center mt-8">
                    <button type="submit" class="bg-blue-700 hover:bg-blue-800 text-white font-bold py-3 px-8 rounded-lg text-lg transition duration-300 ease-in-out transform hover:scale-105">
                        <i class="fas fa-save mr-2"></i>Simpan Data Pelanggan
                    </button>
                </div>
            </form>
        </main>

        <!-- Bagian Syarat & Ketentuan -->
        <section class="p-6 border-t">
            <h3 class="font-bold text-center text-lg mb-4">Terms of Service & Disclaimer</h3>
            <ol class="list-decimal list-inside text-sm text-gray-700 space-y-2">
                <li>Dilarang digunakan untuk akses semua layanan/website yang dilarang Kominfo & Tindak pidana, Seperti Website Pornografi, kekerasan, Judi Online, dan Teroris, Serta lain sebagainya yang melanggar menurut aturan perundang-undangan Negara Republik Indonesia.</li>
                <li>Dilarang dijual kembali baik Paralel atau FTTH tanpa seizin penyedia layanan ISP.</li>
                <li>Tidak Boleh memodifikasi atau merubah pengaturan dari modem & kabel distribusi.</li>
                <li>Pihak ISP tidak bertanggung jawab untuk segala pelanggaran yang dilanggar oleh pengguna layanan (Pelanggan).</li>
                <li>Pembayaran maksimal Tanggal 10 Setiap Bulannya, Bila belum melakukan pembayaran atau tidak konfirmasi maka system akan otomatis isolir/menon-aktifkan pengguna atau user tersebut.</li>
                <li>Peralatan DIPINJAMKAN selama berlangganan, dan hanya HAK PAKAI, Bukan Hak Milik.</li>
                <li>Biaya paket sudah termasuk pajak 11%</li>
            </ol>

            <div class="mt-8 flex justify-between items-end">
                <div>
                    <p class="font-bold">0817-228-297 (Office) / salam@majuin.co.id</p>
                    <p class="font-bold text-blue-600">https://majuin.co.id</p>
                </div>
                <div class="text-center">
                     <p class="font-bold">TTD Berlangganan Wajib</p>
                </div>
            </div>
        </section>

        <!-- Bagian Footer -->
        <footer class="bg-blue-700 text-white p-4 flex justify-between items-center">
            <h3 class="text-xl font-bold">THANK YOU FOR YOUR INFORMATION</h3>
            <span class="bg-blue-900 text-sm py-1 px-3 rounded">Version : 1.0.7</span>
        </footer>
    </div>

    <!-- Loading Overlay -->
    <div class="loading-overlay" id="loadingOverlay">
        <div class="loading-spinner">
            <div class="spinner-border text-blue-600" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
            <p class="mt-3 mb-0">Menyimpan data pelanggan...</p>
        </div>
    </div>

    <script>
        // Foto KTP preview
        document.getElementById('foto_ktp').addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    document.getElementById('preview-img').src = e.target.result;
                    document.getElementById('foto-preview').style.display = 'block';
                };
                reader.readAsDataURL(file);
            }
        });
        
        function removeFoto() {
            document.getElementById('foto_ktp').value = '';
            document.getElementById('foto-preview').style.display = 'none';
        }
        
        // AJAX Form submission
        document.getElementById('customerForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const paket = document.querySelector('input[name="paket"]:checked');
            if (!paket) {
                showAlert('Pilih paket internet terlebih dahulu!', 'error');
                return false;
            }
            
            // Show loading overlay
            document.getElementById('loadingOverlay').style.display = 'flex';
            
            // Create FormData
            const formData = new FormData(this);
            
            // Send AJAX request
            fetch('teknisi_add_customer_new.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showAlert(data.message, 'success');
                    // Reset form
                    document.getElementById('customerForm').reset();
                    document.getElementById('foto-preview').style.display = 'none';
                } else {
                    showAlert(data.message, 'error');
                }
            })
            .catch(error => {
                showAlert('Terjadi kesalahan: ' + error.message, 'error');
            })
            .finally(() => {
                // Hide loading overlay
                document.getElementById('loadingOverlay').style.display = 'none';
            });
        });
        
        // Show alert function
        function showAlert(message, type) {
            // Remove existing alerts
            const existingAlerts = document.querySelectorAll('.alert');
            existingAlerts.forEach(alert => alert.remove());
            
            // Create new alert
            const alertDiv = document.createElement('div');
            const bgColor = type === 'success' ? 'bg-green-100 border-green-500 text-green-700' : 'bg-red-100 border-red-500 text-red-700';
            const icon = type === 'success' ? '✓' : '⚠';
            
            alertDiv.className = `alert ${bgColor} border-l-4 p-4 mb-4 rounded`;
            alertDiv.innerHTML = `
                <div class="flex">
                    <div class="flex-shrink-0">
                        <span class="text-lg">${icon}</span>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium">${message}</p>
                    </div>
                </div>
            `;
            
            // Insert alert in alert area
            document.getElementById('alertArea').appendChild(alertDiv);
            
            // Auto dismiss after 5 seconds
            setTimeout(() => {
                if (alertDiv.parentNode) {
                    alertDiv.remove();
                }
            }, 5000);
        }
    </script>
</body>
</html>
