<?php
// Setup Database ENSIA Otomatis
// Engineer On Site App (ENSIA) PT Maintek Juara Intisolusi

$host = 'localhost';
$username = 'root';
$password = '';
$database = 'ensia_db';

echo "<!DOCTYPE html>";
echo "<html lang='id'>";
echo "<head>";
echo "<meta charset='UTF-8'>";
echo "<meta name='viewport' content='width=device-width, initial-scale=1.0'>";
echo "<title>Setup Database - ENSIA</title>";
echo "<link href='https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css' rel='stylesheet'>";
echo "<style>";
echo "body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; display: flex; align-items: center; }";
echo ".setup-card { background: white; border-radius: 15px; box-shadow: 0 15px 35px rgba(0,0,0,0.1); padding: 2rem; }";
echo "</style>";
echo "</head>";
echo "<body>";

echo "<div class='container'>";
echo "<div class='row justify-content-center'>";
echo "<div class='col-md-8'>";
echo "<div class='setup-card'>";

echo "<h3 class='text-center mb-4'>🗄️ Setup Database ENSIA</h3>";

try {
    // Connect to MySQL without database
    $pdo = new PDO("mysql:host=$host", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<div class='alert alert-success'>";
    echo "<h5><i class='fas fa-check-circle me-2'></i>✅ Koneksi MySQL Berhasil!</h5>";
    echo "</div>";
    
    // Check if database exists
    $query = "SHOW DATABASES LIKE '$database'";
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    
    if ($stmt->rowCount() > 0) {
        echo "<div class='alert alert-warning'>";
        echo "<h5><i class='fas fa-exclamation-triangle me-2'></i>⚠️ Database $database Sudah Ada!</h5>";
        echo "<p>Database akan dihapus dan dibuat ulang.</p>";
        echo "</div>";
        
        // Drop database
        $pdo->exec("DROP DATABASE $database");
        echo "<p>✅ Database lama dihapus</p>";
    }
    
    // Create database
    $pdo->exec("CREATE DATABASE $database CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    echo "<p>✅ Database $database dibuat</p>";
    
    // Connect to new database
    $pdo = new PDO("mysql:host=$host;dbname=$database", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Read and execute schema
    $schema = file_get_contents('database/schema.sql');
    $statements = explode(';', $schema);
    
    $success_count = 0;
    $error_count = 0;
    
    foreach ($statements as $statement) {
        $statement = trim($statement);
        if (!empty($statement)) {
            try {
                $pdo->exec($statement);
                $success_count++;
            } catch (PDOException $e) {
                $error_count++;
                echo "<div class='alert alert-danger'>";
                echo "<p><strong>Error:</strong> " . $e->getMessage() . "</p>";
                echo "<p><strong>Statement:</strong> " . substr($statement, 0, 100) . "...</p>";
                echo "</div>";
            }
        }
    }
    
    echo "<div class='alert alert-info'>";
    echo "<h5><i class='fas fa-info-circle me-2'></i>📊 Hasil Setup:</h5>";
    echo "<ul class='mb-0'>";
    echo "<li>✅ Statements berhasil: $success_count</li>";
    echo "<li>❌ Statements error: $error_count</li>";
    echo "</ul>";
    echo "</div>";
    
    // Verify tables
    $query = "SHOW TABLES";
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    echo "<h6>📋 Tabel yang Dibuat:</h6>";
    echo "<ul>";
    foreach ($tables as $table) {
        echo "<li>$table</li>";
    }
    echo "</ul>";
    
    // Check data
    $query = "SELECT COUNT(*) as total FROM users";
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<p><strong>👥 Total Users:</strong> " . $result['total'] . "</p>";
    
    $query = "SELECT COUNT(*) as total FROM customers";
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<p><strong>👤 Total Customers:</strong> " . $result['total'] . "</p>";
    
    $query = "SELECT COUNT(*) as total FROM installations";
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<p><strong>🔧 Total Installations:</strong> " . $result['total'] . "</p>";
    
    echo "<div class='alert alert-success mt-4'>";
    echo "<h5><i class='fas fa-check-circle me-2'></i>🎉 Setup Database Berhasil!</h5>";
    echo "<p>Database ENSIA siap digunakan dengan data sample Sukabumi.</p>";
    echo "</div>";
    
    echo "<div class='text-center mt-4'>";
    echo "<a href='test_db.php' class='btn btn-primary me-2'>";
    echo "<i class='fas fa-database me-2'></i>Test Database";
    echo "</a>";
    echo "<a href='login.php' class='btn btn-success me-2'>";
    echo "<i class='fas fa-sign-in-alt me-2'></i>Masuk ke Aplikasi";
    echo "</a>";
    echo "<a href='login_info.html' class='btn btn-outline-info'>";
    echo "<i class='fas fa-info-circle me-2'></i>Info Login";
    echo "</a>";
    echo "</div>";
    
} catch (PDOException $e) {
    echo "<div class='alert alert-danger'>";
    echo "<h5><i class='fas fa-exclamation-triangle me-2'></i>❌ Error Setup Database!</h5>";
    echo "<p><strong>Error:</strong> " . $e->getMessage() . "</p>";
    echo "<p>Periksa:</p>";
    echo "<ul>";
    echo "<li>MySQL service berjalan</li>";
    echo "<li>Username dan password MySQL benar</li>";
    echo "<li>User memiliki privilege CREATE DATABASE</li>";
    echo "<li>File database/schema.sql ada</li>";
    echo "</ul>";
    echo "</div>";
    
    echo "<div class='text-center mt-4'>";
    echo "<a href='MYSQL_SETUP.md' class='btn btn-outline-primary'>";
    echo "<i class='fas fa-book me-2'></i>Panduan Setup MySQL";
    echo "</a>";
    echo "</div>";
}

echo "</div>";
echo "</div>";
echo "</div>";
echo "</div>";

echo "<script src='https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js'></script>";
echo "<script src='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/js/all.min.js'></script>";
echo "</body>";
echo "</html>";
?>
