<?php
require_once 'config/config.php';
requireRole(['teknisi']);

$database = new Database();
$db = $database->getConnection();

$success = '';
$error = '';

// Handle installation update
if ($_POST && isset($_POST['action'])) {
    $action = $_POST['action'];
    
    if ($action == 'start_installation') {
        $customer_id = (int)$_POST['customer_id'];
        
        // Cek apakah sudah ada instalasi untuk customer ini
        $check_query = "SELECT id FROM installations WHERE customer_id = ?";
        $check_stmt = $db->prepare($check_query);
        $check_stmt->execute([$customer_id]);
        
        if ($check_stmt->rowCount() == 0) {
            // Buat record instalasi baru
            $query = "INSERT INTO installations (customer_id, teknisi_id, status) VALUES (?, ?, 'assigned')";
            $stmt = $db->prepare($query);
            if ($stmt->execute([$customer_id, $_SESSION['user_id']])) {
                $success = 'Instalasi berhasil dimulai!';
            } else {
                $error = 'Gagal memulai instalasi!';
            }
        } else {
            $error = 'Instalasi untuk pelanggan ini sudah ada!';
        }
    } elseif ($action == 'update_installation') {
        $installation_id = (int)$_POST['installation_id'];
        $kabel_meter = (int)$_POST['kabel_meter'];
        $latitude = $_POST['latitude'];
        $longitude = $_POST['longitude'];
        $alamat_instalasi = sanitizeInput($_POST['alamat_instalasi']);
        $catatan = sanitizeInput($_POST['catatan']);
        $status = $_POST['status'];
        
        $query = "UPDATE installations SET 
                  kabel_meter = ?, 
                  latitude = ?, 
                  longitude = ?, 
                  alamat_instalasi = ?, 
                  catatan = ?, 
                  status = ?,
                  tanggal_instalasi = ?,
                  updated_at = NOW()
                  WHERE id = ? AND teknisi_id = ?";
        
        $tanggal_instalasi = ($status == 'completed') ? date('Y-m-d') : null;
        
        $stmt = $db->prepare($query);
        if ($stmt->execute([$kabel_meter, $latitude, $longitude, $alamat_instalasi, $catatan, $status, $tanggal_instalasi, $installation_id, $_SESSION['user_id']])) {
            // Update status customer jika instalasi selesai
            if ($status == 'completed') {
                $update_customer = "UPDATE customers SET status = 'installed' WHERE id = (SELECT customer_id FROM installations WHERE id = ?)";
                $update_stmt = $db->prepare($update_customer);
                $update_stmt->execute([$installation_id]);
            }
            
            // Log aktivitas
            $log_query = "INSERT INTO activity_logs (user_id, action, description, table_name, record_id) VALUES (?, 'update', 'Update data instalasi', 'installations', ?)";
            $log_stmt = $db->prepare($log_query);
            $log_stmt->execute([$_SESSION['user_id'], $installation_id]);
            
            $success = 'Data instalasi berhasil diperbarui!';
        } else {
            $error = 'Gagal memperbarui data instalasi!';
        }
    }
}

// Filter dan pencarian
$search = isset($_GET['search']) ? sanitizeInput($_GET['search']) : '';
$status_filter = isset($_GET['status']) ? sanitizeInput($_GET['status']) : '';

// Query dengan filter
$where_conditions = [];
$params = [];

if (!empty($search)) {
    $where_conditions[] = "(c.nama_lengkap LIKE ? OR c.nomor_hp LIKE ? OR c.email LIKE ?)";
    $search_param = "%$search%";
    $params = array_merge($params, [$search_param, $search_param, $search_param]);
}

if (!empty($status_filter)) {
    $where_conditions[] = "i.status = ?";
    $params[] = $status_filter;
}

$where_clause = !empty($where_conditions) ? 'WHERE ' . implode(' AND ', $where_conditions) : '';

// Query data instalasi
$query = "SELECT i.*, c.nama_lengkap, c.nomor_hp, c.email, c.alamat_lengkap, c.status as customer_status
          FROM installations i
          LEFT JOIN customers c ON i.customer_id = c.id
          $where_clause 
          ORDER BY i.created_at DESC";
$stmt = $db->prepare($query);
$stmt->execute($params);
$installations = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Query pelanggan yang sudah approved tapi belum ada instalasi
$approved_customers_query = "SELECT c.* FROM customers c 
                            LEFT JOIN installations i ON c.id = i.customer_id 
                            WHERE c.status = 'approved' AND i.id IS NULL
                            ORDER BY c.created_at DESC";
$approved_customers_stmt = $db->prepare($approved_customers_query);
$approved_customers_stmt->execute();
$approved_customers = $approved_customers_stmt->fetchAll(PDO::FETCH_ASSOC);

// Statistik
$stats_query = "SELECT 
    COUNT(*) as total,
    SUM(CASE WHEN status = 'assigned' THEN 1 ELSE 0 END) as assigned,
    SUM(CASE WHEN status = 'in_progress' THEN 1 ELSE 0 END) as in_progress,
    SUM(CASE WHEN status = 'completed' THEN 1 ELSE 0 END) as completed,
    SUM(CASE WHEN status = 'failed' THEN 1 ELSE 0 END) as failed
    FROM installations WHERE teknisi_id = ?";
$stats_stmt = $db->prepare($stats_query);
$stats_stmt->execute([$_SESSION['user_id']]);
$stats = $stats_stmt->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instalasi - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .sidebar .logo {
            padding: 1rem;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        .sidebar .logo i {
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.8);
            padding: 0.75rem 1rem;
            border-radius: 0.375rem;
            margin: 0.25rem 0.5rem;
        }
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background: rgba(255,255,255,0.1);
        }
        .main-content {
            background: #f8f9fa;
            min-height: 100vh;
        }
        .header {
            background: white;
            padding: 1rem 2rem;
            border-bottom: 1px solid #dee2e6;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
        }
        .filter-card {
            background: white;
            border-radius: 0.5rem;
            padding: 1.5rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
            margin-bottom: 1.5rem;
        }
        .data-card {
            background: white;
            border-radius: 0.5rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
        }
        .installation-card {
            border: 1px solid #dee2e6;
            border-radius: 0.5rem;
            padding: 1.5rem;
            margin-bottom: 1rem;
            background: white;
        }
        .installation-card:hover {
            box-shadow: 0 0.5rem 1rem rgba(0,0,0,0.15);
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0">
                <div class="sidebar">
                    <div class="logo">
                        <i class="fas fa-wifi"></i>
                        <h6 class="mb-0"><?php echo APP_NAME; ?></h6>
                        <small><?php echo APP_COMPANY; ?></small>
                    </div>
                    <nav class="nav flex-column mt-3">
                        <a class="nav-link" href="dashboard.php">
                            <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                        </a>
                        <a class="nav-link active" href="installations.php">
                            <i class="fas fa-tools me-2"></i>Instalasi
                        </a>
                        <a class="nav-link" href="teknisi_add_customer_new.php">
                            <i class="fas fa-user-plus me-2"></i>Tambah Pelanggan
                        </a>
                        <a class="nav-link" href="installed_customers.php">
                            <i class="fas fa-check-double me-2"></i>Selesai Instalasi
                        </a>
                        <a class="nav-link" href="logout.php">
                            <i class="fas fa-sign-out-alt me-2"></i>Logout
                        </a>
                    </nav>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-0">
                <div class="main-content">
                    <!-- Header -->
                    <div class="header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="mb-0">Data Instalasi</h4>
                            <div class="d-flex align-items-center">
                                <span class="me-3">Selamat datang, <?php echo $_SESSION['full_name']; ?></span>
                                <span class="badge bg-primary"><?php echo ucfirst($_SESSION['user_role']); ?></span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Content -->
                    <div class="p-4">
                        <?php if ($success): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <i class="fas fa-check-circle me-2"></i>
                                <?php echo $success; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($error): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                <?php echo $error; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Statistik -->
                        <div class="row mb-4">
                            <div class="col-md-3 mb-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h5 class="card-title text-primary"><?php echo $stats['total']; ?></h5>
                                        <p class="card-text">Total Instalasi</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 mb-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h5 class="card-title text-warning"><?php echo $stats['assigned']; ?></h5>
                                        <p class="card-text">Ditugaskan</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 mb-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h5 class="card-title text-info"><?php echo $stats['in_progress']; ?></h5>
                                        <p class="card-text">Sedang Berlangsung</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 mb-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h5 class="card-title text-success"><?php echo $stats['completed']; ?></h5>
                                        <p class="card-text">Selesai</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Filter -->
                        <div class="filter-card">
                            <form method="GET" class="row g-3">
                                <div class="col-md-6">
                                    <label for="search" class="form-label">Pencarian</label>
                                    <input type="text" class="form-control" id="search" name="search" 
                                           placeholder="Nama pelanggan, HP, atau Email..." value="<?php echo $search; ?>">
                                </div>
                                <div class="col-md-4">
                                    <label for="status" class="form-label">Status</label>
                                    <select class="form-select" id="status" name="status">
                                        <option value="">Semua Status</option>
                                        <option value="assigned" <?php echo $status_filter == 'assigned' ? 'selected' : ''; ?>>Ditugaskan</option>
                                        <option value="in_progress" <?php echo $status_filter == 'in_progress' ? 'selected' : ''; ?>>Sedang Berlangsung</option>
                                        <option value="completed" <?php echo $status_filter == 'completed' ? 'selected' : ''; ?>>Selesai</option>
                                        <option value="failed" <?php echo $status_filter == 'failed' ? 'selected' : ''; ?>>Gagal</option>
                                    </select>
                                </div>
                                <div class="col-md-2 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary me-2">
                                        <i class="fas fa-search me-2"></i>Cari
                                    </button>
                                    <a href="installations.php" class="btn btn-outline-secondary">
                                        <i class="fas fa-refresh"></i>
                                    </a>
                                </div>
                            </form>
                        </div>
                        
                        <!-- Pelanggan yang Siap Diinstalasi -->
                        <?php if (!empty($approved_customers)): ?>
                            <div class="data-card mb-4">
                                <div class="card-header">
                                    <h5 class="mb-0">Pelanggan Siap Diinstalasi</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <?php foreach ($approved_customers as $customer): ?>
                                            <div class="col-md-6 mb-3">
                                                <div class="card">
                                                    <div class="card-body">
                                                        <h6 class="card-title"><?php echo $customer['nama_lengkap']; ?></h6>
                                                        <p class="card-text">
                                                            <small class="text-muted">
                                                                <i class="fas fa-phone me-1"></i><?php echo $customer['nomor_hp']; ?><br>
                                                                <i class="fas fa-map-marker-alt me-1"></i><?php echo substr($customer['alamat_lengkap'], 0, 50) . '...'; ?>
                                                            </small>
                                                        </p>
                                                        <form method="POST" class="d-inline">
                                                            <input type="hidden" name="action" value="start_installation">
                                                            <input type="hidden" name="customer_id" value="<?php echo $customer['id']; ?>">
                                                            <button type="submit" class="btn btn-success btn-sm">
                                                                <i class="fas fa-play me-2"></i>Mulai Instalasi
                                                            </button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Data Instalasi -->
                        <div class="data-card">
                            <div class="card-header">
                                <h5 class="mb-0">Data Instalasi Saya</h5>
                            </div>
                            <div class="card-body">
                                <?php if (empty($installations)): ?>
                                    <div class="text-center py-5">
                                        <i class="fas fa-tools fa-3x text-muted mb-3"></i>
                                        <p class="text-muted">Tidak ada data instalasi</p>
                                    </div>
                                <?php else: ?>
                                    <?php foreach ($installations as $installation): ?>
                                        <div class="installation-card">
                                            <div class="row">
                                                <div class="col-md-8">
                                                    <h6 class="mb-2"><?php echo $installation['nama_lengkap']; ?></h6>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <p class="mb-1"><strong>Nomor HP:</strong> <?php echo $installation['nomor_hp']; ?></p>
                                                            <p class="mb-1"><strong>Email:</strong> <?php echo $installation['email'] ?: '-'; ?></p>
                                                            <p class="mb-1"><strong>Kabel:</strong> <?php echo $installation['kabel_meter'] ? $installation['kabel_meter'] . ' meter' : '-'; ?></p>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <p class="mb-1"><strong>Status:</strong> 
                                                                <?php
                                                                $status_class = '';
                                                                $status_text = '';
                                                                switch ($installation['status']) {
                                                                    case 'assigned':
                                                                        $status_class = 'warning';
                                                                        $status_text = 'Ditugaskan';
                                                                        break;
                                                                    case 'in_progress':
                                                                        $status_class = 'info';
                                                                        $status_text = 'Sedang Berlangsung';
                                                                        break;
                                                                    case 'completed':
                                                                        $status_class = 'success';
                                                                        $status_text = 'Selesai';
                                                                        break;
                                                                    case 'failed':
                                                                        $status_class = 'danger';
                                                                        $status_text = 'Gagal';
                                                                        break;
                                                                }
                                                                ?>
                                                                <span class="badge bg-<?php echo $status_class; ?>"><?php echo $status_text; ?></span>
                                                            </p>
                                                            <p class="mb-1"><strong>Tanggal Instalasi:</strong> <?php echo $installation['tanggal_instalasi'] ? formatDate($installation['tanggal_instalasi']) : '-'; ?></p>
                                                            <p class="mb-1"><strong>Koordinat:</strong> 
                                                                <?php if ($installation['latitude'] && $installation['longitude']): ?>
                                                                    <?php echo $installation['latitude'] . ', ' . $installation['longitude']; ?>
                                                                <?php else: ?>
                                                                    -
                                                                <?php endif; ?>
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-0"><strong>Alamat Instalasi:</strong> <?php echo $installation['alamat_instalasi'] ?: $installation['alamat_lengkap']; ?></p>
                                                    <?php if ($installation['catatan']): ?>
                                                        <p class="mb-0 mt-2"><strong>Catatan:</strong> <?php echo $installation['catatan']; ?></p>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="col-md-4 text-end">
                                                    <div class="d-grid gap-2">
                                                        <button type="button" class="btn btn-primary btn-sm" 
                                                                data-bs-toggle="modal" data-bs-target="#updateModal<?php echo $installation['id']; ?>">
                                                            <i class="fas fa-edit me-2"></i>Update Data
                                                        </button>
                                                        <?php if ($installation['latitude'] && $installation['longitude']): ?>
                                                            <a href="https://www.google.com/maps?q=<?php echo $installation['latitude']; ?>,<?php echo $installation['longitude']; ?>" 
                                                               target="_blank" class="btn btn-outline-info btn-sm">
                                                                <i class="fas fa-map-marker-alt me-2"></i>Lihat Peta
                                                            </a>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Modal Update -->
                                        <div class="modal fade" id="updateModal<?php echo $installation['id']; ?>" tabindex="-1">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Update Data Instalasi</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                    </div>
                                                    <form method="POST">
                                                        <div class="modal-body">
                                                            <div class="row">
                                                                <div class="col-md-6 mb-3">
                                                                    <label for="kabel_meter_<?php echo $installation['id']; ?>" class="form-label">Panjang Kabel (Meter) *</label>
                                                                    <input type="number" class="form-control" id="kabel_meter_<?php echo $installation['id']; ?>" 
                                                                           name="kabel_meter" value="<?php echo $installation['kabel_meter']; ?>" required>
                                                                </div>
                                                                <div class="col-md-6 mb-3">
                                                                    <label for="status_<?php echo $installation['id']; ?>" class="form-label">Status *</label>
                                                                    <select class="form-select" id="status_<?php echo $installation['id']; ?>" name="status" required>
                                                                        <option value="assigned" <?php echo $installation['status'] == 'assigned' ? 'selected' : ''; ?>>Ditugaskan</option>
                                                                        <option value="in_progress" <?php echo $installation['status'] == 'in_progress' ? 'selected' : ''; ?>>Sedang Berlangsung</option>
                                                                        <option value="completed" <?php echo $installation['status'] == 'completed' ? 'selected' : ''; ?>>Selesai</option>
                                                                        <option value="failed" <?php echo $installation['status'] == 'failed' ? 'selected' : ''; ?>>Gagal</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6 mb-3">
                                                                    <label for="latitude_<?php echo $installation['id']; ?>" class="form-label">Latitude</label>
                                                                    <input type="text" class="form-control" id="latitude_<?php echo $installation['id']; ?>" 
                                                                           name="latitude" value="<?php echo $installation['latitude']; ?>" 
                                                                           placeholder="Contoh: -6.200000">
                                                                </div>
                                                                <div class="col-md-6 mb-3">
                                                                    <label for="longitude_<?php echo $installation['id']; ?>" class="form-label">Longitude</label>
                                                                    <input type="text" class="form-control" id="longitude_<?php echo $installation['id']; ?>" 
                                                                           name="longitude" value="<?php echo $installation['longitude']; ?>" 
                                                                           placeholder="Contoh: 106.816666">
                                                                </div>
                                                            </div>
                                                            <div class="mb-3">
                                                                <label for="alamat_instalasi_<?php echo $installation['id']; ?>" class="form-label">Alamat Instalasi</label>
                                                                <textarea class="form-control" id="alamat_instalasi_<?php echo $installation['id']; ?>" 
                                                                          name="alamat_instalasi" rows="2"><?php echo $installation['alamat_instalasi']; ?></textarea>
                                                            </div>
                                                            <div class="mb-3">
                                                                <label for="catatan_<?php echo $installation['id']; ?>" class="form-label">Catatan</label>
                                                                <textarea class="form-control" id="catatan_<?php echo $installation['id']; ?>" 
                                                                          name="catatan" rows="3" placeholder="Tambahkan catatan instalasi..."><?php echo $installation['catatan']; ?></textarea>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                            <button type="submit" class="btn btn-primary">
                                                                <i class="fas fa-save me-2"></i>Simpan
                                                            </button>
                                                        </div>
                                                        <input type="hidden" name="action" value="update_installation">
                                                        <input type="hidden" name="installation_id" value="<?php echo $installation['id']; ?>">
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Get current location
        function getCurrentLocation(inputId) {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function(position) {
                    const latitude = position.coords.latitude;
                    const longitude = position.coords.longitude;
                    
                    // Find the corresponding input fields
                    const modal = document.querySelector(`#${inputId}`).closest('.modal');
                    const latInput = modal.querySelector('input[name="latitude"]');
                    const lngInput = modal.querySelector('input[name="longitude"]');
                    
                    if (latInput && lngInput) {
                        latInput.value = latitude.toFixed(6);
                        lngInput.value = longitude.toFixed(6);
                    }
                });
            } else {
                alert('Geolocation tidak didukung oleh browser ini.');
            }
        }
        
        // Add location buttons to all modals
        document.addEventListener('DOMContentLoaded', function() {
            const modals = document.querySelectorAll('.modal');
            modals.forEach((modal, index) => {
                const latInput = modal.querySelector('input[name="latitude"]');
                const lngInput = modal.querySelector('input[name="longitude"]');
                
                if (latInput && lngInput) {
                    const locationButton = document.createElement('button');
                    locationButton.type = 'button';
                    locationButton.className = 'btn btn-outline-info btn-sm mt-2';
                    locationButton.innerHTML = '<i class="fas fa-location-arrow me-2"></i>Ambil Lokasi Saat Ini';
                    locationButton.onclick = () => getCurrentLocation(`latitude_${index + 1}`);
                    
                    latInput.parentNode.appendChild(locationButton);
                }
            });
        });
    </script>
</body>
</html>
