<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Demo - Responsive Design Mobile First - ENSIA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="responsive_design.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 2rem 0;
        }
        .header {
            text-align: center;
            color: white;
            margin-bottom: 2rem;
        }
        .header h1 {
            font-size: 2.5rem;
            margin-bottom: 0.5rem;
        }
        .demo-card {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            margin-bottom: 2rem;
        }
        .demo-badge {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
        }
        .feature-card {
            background: white;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .feature-card h6 {
            color: #667eea;
            margin-bottom: 0.5rem;
        }
        .device-info {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
            text-align: center;
        }
        .breakpoint-info {
            background: #e3f2fd;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
        }
        .breakpoint-info h6 {
            color: #1976d2;
            margin-bottom: 0.5rem;
        }
        .breakpoint-info .badge {
            font-size: 0.7rem;
            margin-right: 0.25rem;
        }
        .responsive-demo {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
        }
        .responsive-demo .row {
            margin-bottom: 1rem;
        }
        .responsive-demo .col {
            background: #667eea;
            color: white;
            padding: 1rem;
            border-radius: 5px;
            text-align: center;
            margin-bottom: 0.5rem;
        }
        .chart-demo {
            background: white;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
        }
        .chart-demo .chart-wrapper {
            background: #f8f9fa;
            border-radius: 5px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #666;
            font-size: 0.9rem;
        }
        .mobile-menu-toggle {
            position: fixed;
            top: 1rem;
            left: 1rem;
            z-index: 1060;
            background: #667eea;
            color: white;
            border: none;
            border-radius: 50%;
            width: 50px;
            height: 50px;
            display: none;
            align-items: center;
            justify-content: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
        }
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            transition: left 0.3s ease;
        }
        .sidebar .logo {
            padding: 1rem;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        .sidebar .logo i {
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.8);
            padding: 0.75rem 1rem;
            border-radius: 0.375rem;
            margin: 0.25rem 0.5rem;
        }
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background: rgba(255,255,255,0.1);
        }
        .sidebar-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
            z-index: 1040;
            display: none;
        }
        .sidebar-overlay.show {
            display: block;
        }
        @media (max-width: 767px) {
            .mobile-menu-toggle {
                display: flex;
            }
            .sidebar {
                position: fixed;
                top: 0;
                left: -100%;
                width: 80%;
                height: 100vh;
                z-index: 1050;
            }
            .sidebar.show {
                left: 0;
            }
        }
    </style>
</head>
<body>
    <!-- Mobile Menu Toggle -->
    <button class="mobile-menu-toggle" onclick="toggleSidebar()">
        <i class="fas fa-bars"></i>
    </button>
    
    <!-- Sidebar Overlay -->
    <div class="sidebar-overlay" id="sidebarOverlay" onclick="closeSidebar()"></div>
    
    <!-- Demo Badge -->
    <div class="demo-badge">
        <span class="badge bg-warning fs-6">
            <i class="fas fa-mobile-alt me-1"></i>RESPONSIVE
        </span>
    </div>

    <div class="container-fluid">
        <!-- Header -->
        <div class="header">
            <h1><i class="fas fa-wifi me-3"></i>ENSIA</h1>
            <p>Engineer On Site App - PT Maintek Juara Intisolusi</p>
            <h3>📱 Demo - Responsive Design Mobile First</h3>
            <p class="lead">Aplikasi yang responsif di semua device</p>
        </div>
        
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0">
                <div class="sidebar" id="sidebar">
                    <div class="logo">
                        <i class="fas fa-wifi"></i>
                        <h6 class="mb-0">ENSIA</h6>
                        <small>PT Maintek Juara Intisolusi</small>
                    </div>
                    <nav class="nav flex-column mt-3">
                        <a class="nav-link active" href="#">
                            <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                        </a>
                        <a class="nav-link" href="#">
                            <i class="fas fa-users me-2"></i>Data Pelanggan
                        </a>
                        <a class="nav-link" href="#">
                            <i class="fas fa-user-plus me-2"></i>Tambah Pelanggan
                        </a>
                        <a class="nav-link" href="#">
                            <i class="fas fa-check-circle me-2"></i>Persetujuan
                        </a>
                        <a class="nav-link" href="#">
                            <i class="fas fa-tools me-2"></i>Instalasi
                        </a>
                        <a class="nav-link" href="#">
                            <i class="fas fa-check-double me-2"></i>Selesai Instalasi
                        </a>
                        <a class="nav-link" href="#">
                            <i class="fas fa-chart-bar me-2"></i>Laporan
                        </a>
                        <a class="nav-link" href="#">
                            <i class="fas fa-sign-out-alt me-2"></i>Logout
                        </a>
                    </nav>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-0">
                <div class="main-content">
                    <!-- Header -->
                    <div class="header" style="background: white; color: #333; padding: 1rem 2rem; margin-bottom: 0; border-radius: 0;">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="mb-0">Responsive Design Demo</h4>
                            <div class="d-flex align-items-center">
                                <span class="me-3">Selamat datang, Admin</span>
                                <span class="badge bg-primary">Admin</span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Content -->
                    <div class="p-4">
                        <!-- Device Info -->
                        <div class="device-info">
                            <h6><i class="fas fa-info-circle me-2"></i>Device Information</h6>
                            <p class="mb-0">Screen Width: <span id="screenWidth"></span>px | Viewport: <span id="viewportWidth"></span>px</p>
                        </div>
                        
                        <!-- Breakpoint Info -->
                        <div class="breakpoint-info">
                            <h6><i class="fas fa-mobile-alt me-2"></i>Responsive Breakpoints</h6>
                            <p class="mb-2">Current breakpoint:</p>
                            <span class="badge bg-primary" id="currentBreakpoint">Mobile</span>
                            <span class="badge bg-secondary" id="breakpointInfo">Base styles (320px+)</span>
                        </div>
                        
                        <!-- Stats Cards -->
                        <div class="row mb-4">
                            <div class="col-md-3 mb-3">
                                <div class="stat-card pending">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <h6 class="text-muted mb-1">Pelanggan Baru</h6>
                                            <h3 class="mb-0">12</h3>
                                        </div>
                                        <div class="text-warning">
                                            <i class="fas fa-clock fa-2x"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 mb-3">
                                <div class="stat-card installed">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <h6 class="text-muted mb-1">Sudah Diinstalasi</h6>
                                            <h3 class="mb-0">45</h3>
                                        </div>
                                        <div class="text-success">
                                            <i class="fas fa-check-circle fa-2x"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 mb-3">
                                <div class="stat-card waiting">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <h6 class="text-muted mb-1">Menunggu Instalasi</h6>
                                            <h3 class="mb-0">8</h3>
                                        </div>
                                        <div class="text-info">
                                            <i class="fas fa-home fa-2x"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 mb-3">
                                <div class="stat-card cancelled">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <h6 class="text-muted mb-1">Dibatalkan</h6>
                                            <h3 class="mb-0">3</h3>
                                        </div>
                                        <div class="text-danger">
                                            <i class="fas fa-times-circle fa-2x"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Responsive Grid Demo -->
                        <div class="responsive-demo">
                            <h6><i class="fas fa-th me-2"></i>Responsive Grid Demo</h6>
                            <div class="row">
                                <div class="col-12 col-md-6 col-lg-3">
                                    <div class="col">Mobile: 12 cols<br>Tablet: 6 cols<br>Desktop: 3 cols</div>
                                </div>
                                <div class="col-12 col-md-6 col-lg-3">
                                    <div class="col">Mobile: 12 cols<br>Tablet: 6 cols<br>Desktop: 3 cols</div>
                                </div>
                                <div class="col-12 col-md-6 col-lg-3">
                                    <div class="col">Mobile: 12 cols<br>Tablet: 6 cols<br>Desktop: 3 cols</div>
                                </div>
                                <div class="col-12 col-md-6 col-lg-3">
                                    <div class="col">Mobile: 12 cols<br>Tablet: 6 cols<br>Desktop: 3 cols</div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Chart Demo -->
                        <div class="chart-demo">
                            <h6><i class="fas fa-chart-line me-2"></i>Responsive Chart Demo</h6>
                            <div class="chart-wrapper">
                                <div>
                                    <i class="fas fa-chart-line fa-3x mb-2"></i>
                                    <p>Chart akan menyesuaikan ukuran layar</p>
                                    <small>Mobile: 250px | Tablet: 300px | Desktop: 400px</small>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Features -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="feature-card">
                                    <h6><i class="fas fa-mobile-alt me-2 text-primary"></i>Mobile First</h6>
                                    <ul class="list-unstyled small">
                                        <li><i class="fas fa-check me-2 text-success"></i>Base styles untuk mobile</li>
                                        <li><i class="fas fa-check me-2 text-success"></i>Progressive enhancement</li>
                                        <li><i class="fas fa-check me-2 text-success"></i>Touch-friendly interface</li>
                                        <li><i class="fas fa-check me-2 text-success"></i>Fast loading</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="feature-card">
                                    <h6><i class="fas fa-desktop me-2 text-info"></i>Desktop Enhancement</h6>
                                    <ul class="list-unstyled small">
                                        <li><i class="fas fa-check me-2 text-success"></i>Larger screens optimized</li>
                                        <li><i class="fas fa-check me-2 text-success"></i>More content visible</li>
                                        <li><i class="fas fa-check me-2 text-success"></i>Hover effects</li>
                                        <li><i class="fas fa-check me-2 text-success"></i>Better typography</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Breakpoint Details -->
                        <div class="row">
                            <div class="col-md-4">
                                <div class="feature-card">
                                    <h6><i class="fas fa-mobile me-2 text-warning"></i>Mobile (320px+)</h6>
                                    <ul class="list-unstyled small">
                                        <li>• Sidebar collapsible</li>
                                        <li>• Single column layout</li>
                                        <li>• Touch-friendly buttons</li>
                                        <li>• Optimized typography</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="feature-card">
                                    <h6><i class="fas fa-tablet me-2 text-info"></i>Tablet (768px+)</h6>
                                    <ul class="list-unstyled small">
                                        <li>• Sidebar visible</li>
                                        <li>• Two column layout</li>
                                        <li>• Medium typography</li>
                                        <li>• Better spacing</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="feature-card">
                                    <h6><i class="fas fa-desktop me-2 text-success"></i>Desktop (992px+)</h6>
                                    <ul class="list-unstyled small">
                                        <li>• Full sidebar</li>
                                        <li>• Multi column layout</li>
                                        <li>• Large typography</li>
                                        <li>• Hover effects</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Footer -->
        <div class="text-center mt-4">
            <p class="text-white">
                <i class="fas fa-code me-2"></i>
                Developed by Amiruloh untuk Tugas Akhir D3 Manajemen Informatika AMIK CBI Sukabumi
            </p>
            <a href="login.php" class="btn btn-light me-2">
                <i class="fas fa-sign-in-alt me-2"></i>Login ke Aplikasi
            </a>
            <a href="demo_add_customer.php" class="btn btn-outline-light">
                <i class="fas fa-user-plus me-2"></i>Demo Tambah Pelanggan
            </a>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Update device info
        function updateDeviceInfo() {
            document.getElementById('screenWidth').textContent = screen.width;
            document.getElementById('viewportWidth').textContent = window.innerWidth;
            
            const width = window.innerWidth;
            let breakpoint = 'Mobile';
            let info = 'Base styles (320px+)';
            
            if (width >= 1400) {
                breakpoint = 'Extra Large Desktop';
                info = '1400px+';
            } else if (width >= 1200) {
                breakpoint = 'Large Desktop';
                info = '1200px+';
            } else if (width >= 992) {
                breakpoint = 'Desktop';
                info = '992px+';
            } else if (width >= 768) {
                breakpoint = 'Tablet';
                info = '768px+';
            } else {
                breakpoint = 'Mobile';
                info = '320px+';
            }
            
            document.getElementById('currentBreakpoint').textContent = breakpoint;
            document.getElementById('breakpointInfo').textContent = info;
        }
        
        // Toggle sidebar on mobile
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebarOverlay');
            
            sidebar.classList.toggle('show');
            overlay.classList.toggle('show');
        }
        
        function closeSidebar() {
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebarOverlay');
            
            sidebar.classList.remove('show');
            overlay.classList.remove('show');
        }
        
        // Update on resize
        window.addEventListener('resize', updateDeviceInfo);
        
        // Initial update
        updateDeviceInfo();
        
        // Close sidebar when clicking on nav links
        document.querySelectorAll('.nav-link').forEach(link => {
            link.addEventListener('click', closeSidebar);
        });
    </script>
</body>
</html>
