<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Demo - Kelola Teknisi - Admin - ENSIA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 2rem 0;
        }
        .header {
            text-align: center;
            color: white;
            margin-bottom: 2rem;
        }
        .header h1 {
            font-size: 2.5rem;
            margin-bottom: 0.5rem;
        }
        .demo-card {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            margin-bottom: 2rem;
        }
        .demo-badge {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
        }
        .feature-card {
            background: white;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .feature-card h6 {
            color: #667eea;
            margin-bottom: 0.5rem;
        }
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            margin-bottom: 1.5rem;
        }
        .card-header {
            background: linear-gradient(45deg, #667eea, #764ba2);
            color: white;
            border-radius: 10px 10px 0 0;
            padding: 1rem 1.5rem;
        }
        .btn-primary {
            background: linear-gradient(45deg, #667eea, #764ba2);
            border: none;
        }
        .btn-primary:hover {
            background: linear-gradient(45deg, #5a6fd8, #6a4190);
        }
        .technician-card {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
            border-left: 4px solid #667eea;
        }
        .customer-card {
            background: #e3f2fd;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
            border-left: 4px solid #2196f3;
        }
        .badge-status {
            font-size: 0.75rem;
            padding: 0.5rem 0.75rem;
        }
    </style>
</head>
<body>
    <!-- Demo Badge -->
    <div class="demo-badge">
        <span class="badge bg-warning fs-6">
            <i class="fas fa-flask me-1"></i>DEMO
        </span>
    </div>

    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1><i class="fas fa-wifi me-3"></i>ENSIA</h1>
            <p>Engineer On Site App - PT Maintek Juara Intisolusi</p>
            <h3>👨‍💼 Demo - Kelola Teknisi (Admin)</h3>
            <p class="lead">Admin dapat mengelola master data teknisi dan menugaskan teknisi ke pelanggan</p>
        </div>
        
        <!-- Features Info -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="feature-card">
                    <h6><i class="fas fa-user-plus me-2"></i>Tambah Teknisi</h6>
                    <p class="text-muted small mb-0">Admin dapat menambah teknisi baru dengan data lengkap</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="feature-card">
                    <h6><i class="fas fa-tasks me-2"></i>Tugaskan Teknisi</h6>
                    <p class="text-muted small mb-0">Admin dapat menugaskan teknisi ke pelanggan yang approved</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="feature-card">
                    <h6><i class="fas fa-list me-2"></i>Daftar Teknisi</h6>
                    <p class="text-muted small mb-0">Lihat semua teknisi yang terdaftar dalam sistem</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="feature-card">
                    <h6><i class="fas fa-chart-line me-2"></i>Monitoring</h6>
                    <p class="text-muted small mb-0">Pantau penugasan dan status kerja teknisi</p>
                </div>
            </div>
        </div>
        
        <!-- Add Technician Form -->
        <div class="demo-card">
            <h4 class="mb-4">
                <i class="fas fa-user-plus me-2"></i>Form Tambah Teknisi Baru
                <span class="badge bg-primary ms-2">Admin Only</span>
            </h4>
            
            <form>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="nama_teknisi" class="form-label">Nama Teknisi <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="nama_teknisi" value="Ahmad Teknisi" readonly>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="nomor_hp" class="form-label">Nomor HP <span class="text-danger">*</span></label>
                        <input type="tel" class="form-control" id="nomor_hp" value="081234567890" readonly>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                        <input type="email" class="form-control" id="email" value="ahmad.teknisi@majuin.co.id" readonly>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="username" class="form-label">Username <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="username" value="ahmad_teknisi" readonly>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="password" class="form-label">Password <span class="text-danger">*</span></label>
                        <input type="password" class="form-control" id="password" value="password123" readonly>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">&nbsp;</label>
                        <button type="button" class="btn btn-primary w-100" onclick="simulateAddTechnician()">
                            <i class="fas fa-plus me-2"></i>Tambah Teknisi
                        </button>
                    </div>
                </div>
            </form>
        </div>
        
        <!-- Assign Technician Form -->
        <div class="demo-card">
            <h4 class="mb-4">
                <i class="fas fa-tasks me-2"></i>Form Tugaskan Teknisi
                <span class="badge bg-info ms-2">Assignment</span>
            </h4>
            
            <form>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="customer_id" class="form-label">Pilih Pelanggan <span class="text-danger">*</span></label>
                        <select class="form-select" id="customer_id" disabled>
                            <option value="">-- Pilih Pelanggan --</option>
                            <option value="1" selected>Budi Santoso - 081234567897</option>
                            <option value="2">Siti Nurhaliza - 081234567891</option>
                            <option value="3">Eko Prasetyo - 081234567895</option>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="teknisi_id" class="form-label">Pilih Teknisi <span class="text-danger">*</span></label>
                        <select class="form-select" id="teknisi_id" disabled>
                            <option value="">-- Pilih Teknisi --</option>
                            <option value="1" selected>Ahmad Teknisi - 081234567890</option>
                            <option value="2">Budi Teknisi - 081234567891</option>
                            <option value="3">Siti Teknisi - 081234567892</option>
                        </select>
                    </div>
                </div>
                <div class="text-end">
                    <button type="button" class="btn btn-primary" onclick="simulateAssignTechnician()">
                        <i class="fas fa-user-check me-2"></i>Tugaskan Teknisi
                    </button>
                </div>
            </form>
        </div>
        
        <!-- Technicians List -->
        <div class="demo-card">
            <h4 class="mb-4">
                <i class="fas fa-list me-2"></i>Daftar Teknisi
                <span class="badge bg-success ms-2">3 Teknisi</span>
            </h4>
            
            <div class="row">
                <div class="col-md-6 col-lg-4 mb-3">
                    <div class="technician-card">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <h6 class="mb-0">Ahmad Teknisi</h6>
                            <span class="badge bg-success badge-status">Aktif</span>
                        </div>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-phone me-1"></i>081234567890
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-envelope me-1"></i>ahmad.teknisi@majuin.co.id
                        </p>
                        <p class="text-muted small mb-2">
                            <i class="fas fa-user me-1"></i>ahmad_teknisi
                        </p>
                        <small class="text-muted">
                            <i class="fas fa-calendar me-1"></i>
                            Dibuat: 15 Jan 2024
                        </small>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4 mb-3">
                    <div class="technician-card">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <h6 class="mb-0">Budi Teknisi</h6>
                            <span class="badge bg-success badge-status">Aktif</span>
                        </div>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-phone me-1"></i>081234567891
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-envelope me-1"></i>budi.teknisi@majuin.co.id
                        </p>
                        <p class="text-muted small mb-2">
                            <i class="fas fa-user me-1"></i>budi_teknisi
                        </p>
                        <small class="text-muted">
                            <i class="fas fa-calendar me-1"></i>
                            Dibuat: 16 Jan 2024
                        </small>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4 mb-3">
                    <div class="technician-card">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <h6 class="mb-0">Siti Teknisi</h6>
                            <span class="badge bg-success badge-status">Aktif</span>
                        </div>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-phone me-1"></i>081234567892
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-envelope me-1"></i>siti.teknisi@majuin.co.id
                        </p>
                        <p class="text-muted small mb-2">
                            <i class="fas fa-user me-1"></i>siti_teknisi
                        </p>
                        <small class="text-muted">
                            <i class="fas fa-calendar me-1"></i>
                            Dibuat: 17 Jan 2024
                        </small>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Assignment List -->
        <div class="demo-card">
            <h4 class="mb-4">
                <i class="fas fa-tasks me-2"></i>Penugasan Teknisi
                <span class="badge bg-info ms-2">5 Penugasan</span>
            </h4>
            
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Pelanggan</th>
                            <th>Teknisi</th>
                            <th>Status</th>
                            <th>Tanggal Tugas</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Budi Santoso</td>
                            <td>Ahmad Teknisi</td>
                            <td><span class="badge bg-warning badge-status">Assigned</span></td>
                            <td>15 Jan 2024 10:30</td>
                            <td>
                                <button class="btn btn-sm btn-outline-primary" onclick="viewAssignment()">
                                    <i class="fas fa-eye me-1"></i>Lihat
                                </button>
                            </td>
                        </tr>
                        <tr>
                            <td>Siti Nurhaliza</td>
                            <td>Budi Teknisi</td>
                            <td><span class="badge bg-info badge-status">In Progress</span></td>
                            <td>16 Jan 2024 14:15</td>
                            <td>
                                <button class="btn btn-sm btn-outline-primary" onclick="viewAssignment()">
                                    <i class="fas fa-eye me-1"></i>Lihat
                                </button>
                            </td>
                        </tr>
                        <tr>
                            <td>Eko Prasetyo</td>
                            <td>Siti Teknisi</td>
                            <td><span class="badge bg-success badge-status">Completed</span></td>
                            <td>17 Jan 2024 09:45</td>
                            <td>
                                <button class="btn btn-sm btn-outline-primary" onclick="viewAssignment()">
                                    <i class="fas fa-eye me-1"></i>Lihat
                                </button>
                            </td>
                        </tr>
                        <tr>
                            <td>Rudi Hartono</td>
                            <td>Ahmad Teknisi</td>
                            <td><span class="badge bg-info badge-status">In Progress</span></td>
                            <td>18 Jan 2024 11:20</td>
                            <td>
                                <button class="btn btn-sm btn-outline-primary" onclick="viewAssignment()">
                                    <i class="fas fa-eye me-1"></i>Lihat
                                </button>
                            </td>
                        </tr>
                        <tr>
                            <td>Maya Sari</td>
                            <td>Budi Teknisi</td>
                            <td><span class="badge bg-warning badge-status">Assigned</span></td>
                            <td>19 Jan 2024 16:00</td>
                            <td>
                                <button class="btn btn-sm btn-outline-primary" onclick="viewAssignment()">
                                    <i class="fas fa-eye me-1"></i>Lihat
                                </button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        
        <!-- Workflow -->
        <div class="demo-card">
            <h4 class="mb-4">
                <i class="fas fa-route me-2"></i>Workflow Kelola Teknisi
            </h4>
            <div class="row">
                <div class="col-md-3">
                    <div class="text-center">
                        <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                            <i class="fas fa-user-plus fa-lg"></i>
                        </div>
                        <h6 class="mt-2">1. Tambah Teknisi</h6>
                        <p class="small text-muted">Admin menambah teknisi baru dengan data lengkap</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center">
                        <div class="bg-warning text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                            <i class="fas fa-tasks fa-lg"></i>
                        </div>
                        <h6 class="mt-2">2. Tugaskan Teknisi</h6>
                        <p class="small text-muted">Admin menugaskan teknisi ke pelanggan yang approved</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center">
                        <div class="bg-info text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                            <i class="fas fa-tools fa-lg"></i>
                        </div>
                        <h6 class="mt-2">3. Teknisi Kerja</h6>
                        <p class="small text-muted">Teknisi melakukan instalasi sesuai penugasan</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center">
                        <div class="bg-success text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                            <i class="fas fa-check fa-lg"></i>
                        </div>
                        <h6 class="mt-2">4. Monitoring</h6>
                        <p class="small text-muted">Admin memantau progress dan status kerja</p>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Footer -->
        <div class="text-center mt-4">
            <p class="text-white">
                <i class="fas fa-code me-2"></i>
                Developed by Amiruloh untuk Tugas Akhir D3 Manajemen Informatika AMIK CBI Sukabumi
            </p>
            <a href="login.php" class="btn btn-light me-2">
                <i class="fas fa-sign-in-alt me-2"></i>Login ke Aplikasi
            </a>
            <a href="demo_teknisi_add_customer_new.php" class="btn btn-outline-light">
                <i class="fas fa-user-plus me-2"></i>Demo Form Pelanggan
            </a>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function simulateAddTechnician() {
            alert('Teknisi berhasil ditambahkan!\n\nNama: Ahmad Teknisi\nHP: 081234567890\nEmail: ahmad.teknisi@majuin.co.id\nUsername: ahmad_teknisi\n\nTeknisi dapat login dengan username dan password yang diberikan.');
        }
        
        function simulateAssignTechnician() {
            alert('Teknisi berhasil ditugaskan!\n\nPelanggan: Budi Santoso\nTeknisi: Ahmad Teknisi\nStatus: Assigned\n\nTeknisi akan menerima notifikasi penugasan dan dapat mulai melakukan instalasi.');
        }
        
        function viewAssignment() {
            alert('Membuka detail penugasan teknisi...\n\nFitur ini akan menampilkan:\n- Detail pelanggan\n- Detail teknisi\n- Status instalasi\n- Progress kerja\n- Data instalasi lengkap');
        }
    </script>
</body>
</html>

