<?php
require_once 'config/config.php';
requireRole(['admin', 'supervisor', 'teknisi']);

$database = new Database();
$db = $database->getConnection();

// Statistik untuk dashboard
$stats = [];

// Total pelanggan baru (pending)
$query = "SELECT COUNT(*) as total FROM customers WHERE status = 'pending'";
$stmt = $db->prepare($query);
$stmt->execute();
$stats['pending'] = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

// Total pelanggan sudah diinstalasi
$query = "SELECT COUNT(*) as total FROM customers WHERE status = 'installed'";
$stmt = $db->prepare($query);
$stmt->execute();
$stats['installed'] = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

// Total pelanggan pending (tidak ada di rumah)
$query = "SELECT COUNT(*) as total FROM customers c 
          LEFT JOIN installations i ON c.id = i.customer_id 
          WHERE c.status = 'approved' AND (i.status = 'assigned' OR i.status = 'in_progress')";
$stmt = $db->prepare($query);
$stmt->execute();
$stats['waiting_install'] = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

// Total pelanggan batal
$query = "SELECT COUNT(*) as total FROM customers WHERE status = 'cancelled'";
$stmt = $db->prepare($query);
$stmt->execute();
$stats['cancelled'] = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

// Filter periode grafik (default: bulan)
$period = isset($_GET['period']) ? $_GET['period'] : 'month';

// Data grafik pemasangan berdasarkan periode
$chart_data = [];
$chart_labels = [];
$chart_values = [];

if ($period == 'day') {
    // Data per hari (30 hari terakhir)
    $query = "SELECT 
                DATE(created_at) as tanggal,
                COUNT(*) as total
              FROM customers 
              WHERE status = 'installed' 
              AND created_at >= DATE_SUB(NOW(), INTERVAL 30 DAY)
              GROUP BY DATE(created_at)
              ORDER BY tanggal ASC";
    $stmt = $db->prepare($query);
    $stmt->execute();
    $chart_data = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($chart_data as $data) {
        $chart_labels[] = date('d M', strtotime($data['tanggal']));
        $chart_values[] = $data['total'];
    }
} elseif ($period == 'week') {
    // Data per minggu (12 minggu terakhir)
    $query = "SELECT 
                YEARWEEK(created_at, 1) as minggu,
                COUNT(*) as total
              FROM customers 
              WHERE status = 'installed' 
              AND created_at >= DATE_SUB(NOW(), INTERVAL 12 WEEK)
              GROUP BY YEARWEEK(created_at, 1)
              ORDER BY minggu ASC";
    $stmt = $db->prepare($query);
    $stmt->execute();
    $chart_data = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($chart_data as $data) {
        $year = substr($data['minggu'], 0, 4);
        $week = substr($data['minggu'], 4, 2);
        $chart_labels[] = "Minggu $week $year";
        $chart_values[] = $data['total'];
    }
} else {
    // Data per bulan (6 bulan terakhir) - default
    $query = "SELECT 
                DATE_FORMAT(created_at, '%Y-%m') as bulan,
                COUNT(*) as total
              FROM customers 
              WHERE status = 'installed' 
              AND created_at >= DATE_SUB(NOW(), INTERVAL 6 MONTH)
              GROUP BY DATE_FORMAT(created_at, '%Y-%m')
              ORDER BY bulan ASC";
    $stmt = $db->prepare($query);
    $stmt->execute();
    $chart_data = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($chart_data as $data) {
        $chart_labels[] = date('M Y', strtotime($data['bulan'] . '-01'));
        $chart_values[] = $data['total'];
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .sidebar .logo {
            padding: 1rem;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        .sidebar .logo i {
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.8);
            padding: 0.75rem 1rem;
            border-radius: 0.375rem;
            margin: 0.25rem 0.5rem;
        }
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background: rgba(255,255,255,0.1);
        }
        .main-content {
            background: #f8f9fa;
            min-height: 100vh;
        }
        .header {
            background: white;
            padding: 1rem 2rem;
            border-bottom: 1px solid #dee2e6;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
        }
        .stat-card {
            background: white;
            border-radius: 0.5rem;
            padding: 1.5rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
            border-left: 4px solid;
        }
        .stat-card.pending { border-left-color: #ffc107; }
        .stat-card.installed { border-left-color: #28a745; }
        .stat-card.waiting { border-left-color: #17a2b8; }
        .stat-card.cancelled { border-left-color: #dc3545; }
        .chart-container {
            background: white;
            border-radius: 0.5rem;
            padding: 1.5rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
        }
        .chart-wrapper {
            position: relative;
            height: 400px;
            width: 100%;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0">
                <div class="sidebar">
                    <div class="logo">
                        <i class="fas fa-wifi"></i>
                        <h6 class="mb-0"><?php echo APP_NAME; ?></h6>
                        <small><?php echo APP_COMPANY; ?></small>
                    </div>
                    <nav class="nav flex-column mt-3">
                        <a class="nav-link active" href="dashboard.php">
                            <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                        </a>
                        <?php if ($_SESSION['user_role'] == 'admin'): ?>
                        <a class="nav-link" href="customers.php">
                            <i class="fas fa-users me-2"></i>Data Pelanggan
                        </a>
                        <a class="nav-link" href="add_customer.php">
                            <i class="fas fa-user-plus me-2"></i>Tambah Pelanggan
                        </a>
                        <?php endif; ?>
                        <?php if ($_SESSION['user_role'] == 'supervisor'): ?>
                        <a class="nav-link" href="approvals.php">
                            <i class="fas fa-check-circle me-2"></i>Persetujuan
                        </a>
                        <?php endif; ?>
                        <?php if ($_SESSION['user_role'] == 'teknisi'): ?>
                        <a class="nav-link" href="installations.php">
                            <i class="fas fa-tools me-2"></i>Instalasi
                        </a>
                        <?php endif; ?>
                        <a class="nav-link" href="installed_customers.php">
                            <i class="fas fa-check-double me-2"></i>Selesai Instalasi
                        </a>
                        <?php if ($_SESSION['user_role'] == 'admin'): ?>
                        <a class="nav-link" href="admin_manage_technicians.php">
                            <i class="fas fa-users-cog me-2"></i>Kelola Teknisi
                        </a>
                        <a class="nav-link" href="reports.php">
                            <i class="fas fa-chart-bar me-2"></i>Laporan
                        </a>
                        <?php endif; ?>
                        <a class="nav-link" href="logout.php">
                            <i class="fas fa-sign-out-alt me-2"></i>Logout
                        </a>
                    </nav>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-0">
                <div class="main-content">
                    <!-- Header -->
                    <div class="header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="mb-0">Dashboard</h4>
                            <div class="d-flex align-items-center">
                                <span class="me-3">Selamat datang, <?php echo $_SESSION['full_name']; ?></span>
                                <span class="badge bg-primary"><?php echo ucfirst($_SESSION['user_role']); ?></span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Content -->
                    <div class="p-4">
                        <!-- Statistik Cards -->
                        <div class="row mb-4">
                            <div class="col-md-3 mb-3">
                                <div class="stat-card pending">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <h6 class="text-muted mb-1">Pelanggan Baru</h6>
                                            <h3 class="mb-0"><?php echo $stats['pending']; ?></h3>
                                        </div>
                                        <div class="text-warning">
                                            <i class="fas fa-clock fa-2x"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 mb-3">
                                <div class="stat-card installed">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <h6 class="text-muted mb-1">Sudah Diinstalasi</h6>
                                            <h3 class="mb-0"><?php echo $stats['installed']; ?></h3>
                                        </div>
                                        <div class="text-success">
                                            <i class="fas fa-check-circle fa-2x"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 mb-3">
                                <div class="stat-card waiting">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <h6 class="text-muted mb-1">Menunggu Instalasi</h6>
                                            <h3 class="mb-0"><?php echo $stats['waiting_install']; ?></h3>
                                        </div>
                                        <div class="text-info">
                                            <i class="fas fa-home fa-2x"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 mb-3">
                                <div class="stat-card cancelled">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <h6 class="text-muted mb-1">Dibatalkan</h6>
                                            <h3 class="mb-0"><?php echo $stats['cancelled']; ?></h3>
                                        </div>
                                        <div class="text-danger">
                                            <i class="fas fa-times-circle fa-2x"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Grafik -->
                        <div class="row">
                            <div class="col-12">
                                <div class="chart-container">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <h5 class="mb-0">Grafik Pemasangan</h5>
                                        <div class="btn-group" role="group">
                                            <a href="?period=day" class="btn btn-sm <?php echo $period == 'day' ? 'btn-primary' : 'btn-outline-primary'; ?>">
                                                <i class="fas fa-calendar-day me-1"></i>Hari
                                            </a>
                                            <a href="?period=week" class="btn btn-sm <?php echo $period == 'week' ? 'btn-primary' : 'btn-outline-primary'; ?>">
                                                <i class="fas fa-calendar-week me-1"></i>Minggu
                                            </a>
                                            <a href="?period=month" class="btn btn-sm <?php echo $period == 'month' ? 'btn-primary' : 'btn-outline-primary'; ?>">
                                                <i class="fas fa-calendar-alt me-1"></i>Bulan
                                            </a>
                                        </div>
                                    </div>
                                    <div class="chart-wrapper">
                                        <canvas id="installationChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Grafik pemasangan
        const ctx = document.getElementById('installationChart').getContext('2d');
        
        // Label berdasarkan periode
        const period = '<?php echo $period; ?>';
        let chartLabel = '';
        switch(period) {
            case 'day':
                chartLabel = 'Pemasangan per Hari (30 hari terakhir)';
                break;
            case 'week':
                chartLabel = 'Pemasangan per Minggu (12 minggu terakhir)';
                break;
            case 'month':
            default:
                chartLabel = 'Pemasangan per Bulan (6 bulan terakhir)';
                break;
        }
        
        new Chart(ctx, {
            type: 'line',
            data: {
                labels: <?php echo json_encode($chart_labels); ?>,
                datasets: [{
                    label: chartLabel,
                    data: <?php echo json_encode($chart_values); ?>,
                    borderColor: '#667eea',
                    backgroundColor: 'rgba(102, 126, 234, 0.1)',
                    tension: 0.4,
                    fill: true,
                    pointBackgroundColor: '#667eea',
                    pointBorderColor: '#ffffff',
                    pointBorderWidth: 2,
                    pointRadius: 5,
                    pointHoverRadius: 7
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                aspectRatio: 2.5,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1,
                            precision: 0
                        },
                        grid: {
                            color: 'rgba(0,0,0,0.1)'
                        }
                    },
                    x: {
                        grid: {
                            color: 'rgba(0,0,0,0.1)'
                        }
                    }
                },
                plugins: {
                    legend: {
                        display: true,
                        position: 'top'
                    },
                    tooltip: {
                        mode: 'index',
                        intersect: false,
                        backgroundColor: 'rgba(0,0,0,0.8)',
                        titleColor: '#ffffff',
                        bodyColor: '#ffffff',
                        borderColor: '#667eea',
                        borderWidth: 1
                    }
                },
                interaction: {
                    mode: 'nearest',
                    axis: 'x',
                    intersect: false
                }
            }
        });
    </script>
</body>
</html>
