<?php
require_once 'config/config.php';
requireRole(['admin']);

$database = new Database();
$db = $database->getConnection();

$success = '';
$error = '';

if (isset($_GET['id'])) {
    $customer_id = (int)$_GET['id'];
    $confirm = isset($_GET['confirm']) && $_GET['confirm'] == 'yes';
    
    // Cek apakah pelanggan ada
    $check_query = "SELECT * FROM customers WHERE id = ?";
    $check_stmt = $db->prepare($check_query);
    $check_stmt->execute([$customer_id]);
    $customer = $check_stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$customer) {
        $error = 'Data pelanggan tidak ditemukan!';
    } else if ($confirm) {
        // Cek apakah pelanggan sudah ada instalasi
        $install_query = "SELECT COUNT(*) as total FROM installations WHERE customer_id = ?";
        $install_stmt = $db->prepare($install_query);
        $install_stmt->execute([$customer_id]);
        $install_count = $install_stmt->fetch(PDO::FETCH_ASSOC)['total'];
        
        if ($install_count > 0) {
            $error = 'Tidak dapat menghapus pelanggan yang sudah memiliki data instalasi!';
        } else {
            // Hapus foto KTP jika ada
            if (!empty($customer['foto_ktp'])) {
                $foto_path = 'uploads/ktp/' . $customer['foto_ktp'];
                if (file_exists($foto_path)) {
                    unlink($foto_path);
                }
            }
            
            // Hapus data pelanggan
            $delete_query = "DELETE FROM customers WHERE id = ?";
            $delete_stmt = $db->prepare($delete_query);
            
            if ($delete_stmt->execute([$customer_id])) {
                // Log aktivitas
                $log_query = "INSERT INTO activity_logs (user_id, action, description, table_name, record_id) VALUES (?, 'delete', 'Menghapus data pelanggan', 'customers', ?)";
                $log_stmt = $db->prepare($log_query);
                $log_stmt->execute([$_SESSION['user_id'], $customer_id]);
                
                $success = 'Data pelanggan berhasil dihapus!';
                
                // Redirect ke halaman customers setelah 2 detik
                header("refresh:2;url=customers.php");
            } else {
                $error = 'Gagal menghapus data pelanggan!';
            }
        }
    }
    // Jika tidak ada konfirmasi, tampilkan halaman konfirmasi
} else {
    $error = 'ID pelanggan tidak valid!';
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hapus Data Pelanggan - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        .delete-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            padding: 2rem;
            max-width: 500px;
            margin: 0 auto;
        }
        .warning-icon {
            font-size: 4rem;
            color: #dc3545;
            margin-bottom: 1rem;
        }
        .customer-info {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 1rem;
            margin: 1rem 0;
        }
        .btn-delete {
            background: #dc3545;
            border-color: #dc3545;
            color: white;
        }
        .btn-delete:hover {
            background: #c82333;
            border-color: #bd2130;
            color: white;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="delete-card">
            <?php if ($success): ?>
                <div class="text-center">
                    <i class="fas fa-check-circle warning-icon text-success"></i>
                    <h4 class="text-success">Berhasil!</h4>
                    <p class="text-muted"><?php echo $success; ?></p>
                    <p class="text-muted small">Anda akan diarahkan ke halaman data pelanggan...</p>
                    <div class="spinner-border text-success" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            <?php elseif ($error): ?>
                <div class="text-center">
                    <i class="fas fa-exclamation-triangle warning-icon"></i>
                    <h4 class="text-danger">Error!</h4>
                    <p class="text-muted"><?php echo $error; ?></p>
                    <a href="customers.php" class="btn btn-primary">
                        <i class="fas fa-arrow-left me-2"></i>Kembali ke Data Pelanggan
                    </a>
                </div>
            <?php else: ?>
                <div class="text-center">
                    <i class="fas fa-exclamation-triangle warning-icon"></i>
                    <h4 class="text-danger">Konfirmasi Hapus</h4>
                    <p class="text-muted">Apakah Anda yakin ingin menghapus data pelanggan ini?</p>
                    
                    <?php if ($customer): ?>
                    <div class="customer-info">
                        <h6><i class="fas fa-user me-2"></i><?php echo htmlspecialchars($customer['nama_lengkap']); ?></h6>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-envelope me-1"></i><?php echo htmlspecialchars($customer['email']); ?>
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-phone me-1"></i><?php echo htmlspecialchars($customer['nomor_hp']); ?>
                        </p>
                        <p class="text-muted small mb-0">
                            <i class="fas fa-id-card me-1"></i><?php echo htmlspecialchars($customer['nik_ktp']); ?>
                        </p>
                    </div>
                    <?php endif; ?>
                    
                    <div class="alert alert-warning">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>Peringatan:</strong> Tindakan ini tidak dapat dibatalkan!
                    </div>
                    
                    <div class="d-flex justify-content-center gap-2">
                        <a href="customers.php" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>Batal
                        </a>
                        <a href="?id=<?php echo $customer_id; ?>&confirm=yes" class="btn btn-delete">
                            <i class="fas fa-trash me-2"></i>Ya, Hapus
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
