# 🗄️ Panduan Setup MySQL untuk Aplikasi ENSIA
## Engineer On Site App (ENSIA) PT Maintek Juara Intisolusi

### 📋 **Persyaratan Sistem**
- **Database**: MySQL 5.7+ atau MariaDB 10.3+
- **PHP**: 7.4+ dengan ekstensi PDO MySQL
- **Web Server**: Apache/Nginx

---

## 🚀 **Instalasi MySQL**

### **1. Ubuntu/Debian**
```bash
# Update package list
sudo apt update

# Install MySQL Server
sudo apt install mysql-server

# Start MySQL service
sudo systemctl start mysql
sudo systemctl enable mysql

# Secure installation
sudo mysql_secure_installation
```

### **2. CentOS/RHEL**
```bash
# Install MySQL Server
sudo yum install mysql-server

# Start MySQL service
sudo systemctl start mysqld
sudo systemctl enable mysqld

# Get temporary password
sudo grep 'temporary password' /var/log/mysqld.log

# Secure installation
sudo mysql_secure_installation
```

### **3. Windows**
1. Download MySQL Installer dari [mysql.com](https://dev.mysql.com/downloads/installer/)
2. Jalankan installer dan pilih "MySQL Server"
3. Ikuti panduan instalasi
4. Set password root saat instalasi

---

## ⚙️ **Konfigurasi Database**

### **1. Login ke MySQL**
```bash
# Login sebagai root
mysql -u root -p
```

### **2. Buat Database**
```sql
-- Buat database ENSIA
CREATE DATABASE ensia_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Buat user khusus untuk aplikasi (opsional)
CREATE USER 'ensia_user'@'localhost' IDENTIFIED BY 'ensia_password';
GRANT ALL PRIVILEGES ON ensia_db.* TO 'ensia_user'@'localhost';
FLUSH PRIVILEGES;

-- Keluar dari MySQL
EXIT;
```

### **3. Import Schema Database**
```bash
# Import schema ke database
mysql -u root -p ensia_db < database/schema.sql

# Atau jika menggunakan user khusus
mysql -u ensia_user -p ensia_db < database/schema.sql
```

---

## 🔧 **Konfigurasi Aplikasi**

### **1. Edit File Konfigurasi Database**
Edit file `config/database.php`:

```php
<?php
class Database {
    private $host = 'localhost';        // Host MySQL
    private $db_name = 'ensia_db';      // Nama database
    private $username = 'root';         // Username MySQL
    private $password = 'your_password'; // Password MySQL
    private $conn;
    
    // ... rest of the code
}
?>
```

### **2. Konfigurasi untuk User Khusus**
Jika menggunakan user khusus:

```php
<?php
class Database {
    private $host = 'localhost';
    private $db_name = 'ensia_db';
    private $username = 'ensia_user';      // User khusus
    private $password = 'ensia_password';  // Password user
    private $conn;
    
    // ... rest of the code
}
?>
```

---

## 🧪 **Testing Koneksi Database**

### **1. Test Koneksi Manual**
Buat file `test_db.php`:

```php
<?php
require_once 'config/database.php';

$database = new Database();
$db = $database->getConnection();

if ($db) {
    echo "✅ Koneksi database berhasil!";
    
    // Test query
    $query = "SELECT COUNT(*) as total FROM users";
    $stmt = $db->prepare($query);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "<br>📊 Total users: " . $result['total'];
} else {
    echo "❌ Koneksi database gagal!";
}
?>
```

### **2. Jalankan Test**
```bash
# Akses via browser
http://localhost/ensia1/test_db.php

# Atau via command line
php test_db.php
```

---

## 📊 **Struktur Database ENSIA**

### **Tabel Utama**
1. **users** - Data admin, supervisor, teknisi
2. **customers** - Data pelanggan lengkap
3. **installations** - Data instalasi dengan GPS
4. **activity_logs** - Log aktivitas sistem

### **Data Sample**
- **5 users** (admin, supervisor, 2 teknisi, manager)
- **9 customers** dengan alamat Sukabumi
- **4 installations** dengan koordinat GPS
- **16 activity logs** untuk tracking

---

## 🔒 **Keamanan Database**

### **1. Backup Database**
```bash
# Backup database
mysqldump -u root -p ensia_db > ensia_backup.sql

# Restore database
mysql -u root -p ensia_db < ensia_backup.sql
```

### **2. Set Password yang Kuat**
```sql
-- Ganti password root
ALTER USER 'root'@'localhost' IDENTIFIED BY 'strong_password';

-- Ganti password user aplikasi
ALTER USER 'ensia_user'@'localhost' IDENTIFIED BY 'strong_password';
```

### **3. Konfigurasi MySQL**
Edit `/etc/mysql/mysql.conf.d/mysqld.cnf`:

```ini
[mysqld]
# Security settings
bind-address = 127.0.0.1
skip-networking = 1
local-infile = 0

# Performance settings
innodb_buffer_pool_size = 128M
query_cache_size = 32M
```

---

## 🚨 **Troubleshooting**

### **Error: Access Denied**
```bash
# Reset password root
sudo mysql
ALTER USER 'root'@'localhost' IDENTIFIED WITH mysql_native_password BY 'new_password';
FLUSH PRIVILEGES;
```

### **Error: Can't Connect to MySQL**
```bash
# Check MySQL status
sudo systemctl status mysql

# Restart MySQL
sudo systemctl restart mysql

# Check port
netstat -tlnp | grep 3306
```

### **Error: Database Not Found**
```sql
-- Check databases
SHOW DATABASES;

-- Create database if missing
CREATE DATABASE ensia_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

---

## 📝 **Panduan Instalasi Lengkap**

### **1. Install MySQL**
```bash
sudo apt update
sudo apt install mysql-server
sudo systemctl start mysql
sudo systemctl enable mysql
```

### **2. Setup Database**
```bash
# Login ke MySQL
sudo mysql

# Buat database
CREATE DATABASE ensia_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
EXIT;

# Import schema
mysql -u root -p ensia_db < database/schema.sql
```

### **3. Install Dependencies**
```bash
cd /home/lab-mji/ensia1
composer install
```

### **4. Test Aplikasi**
```bash
# Akses aplikasi
http://localhost/ensia1

# Login dengan:
# Admin: admin@ensia.com / password
# Supervisor: supervisor@ensia.com / password
# Teknisi: teknisi1@ensia.com / password
```

---

## ✅ **Verifikasi Instalasi**

### **1. Check Database**
```sql
-- Login ke MySQL
mysql -u root -p ensia_db

-- Check tables
SHOW TABLES;

-- Check data
SELECT COUNT(*) FROM users;
SELECT COUNT(*) FROM customers;
SELECT COUNT(*) FROM installations;
```

### **2. Check Aplikasi**
- ✅ Login berhasil
- ✅ Dashboard menampilkan data
- ✅ CRUD pelanggan berfungsi
- ✅ Export PDF/Excel berfungsi

---

**Aplikasi ENSIA siap digunakan dengan MySQL!** 🎉

**Developed by Amiruloh untuk Tugas Akhir D3 Manajemen Informatika AMIK CBI Sukabumi**
